/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.io.IOException;
import org.editorconfig.configmanagement.editor.EditorConfigEditorWithPreview;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewFile;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewFileEditor;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewManager;
import org.editorconfig.configmanagement.editor.EditorConfigStatusListener;
import org.editorconfig.language.filetype.EditorConfigFileType;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigEditorProvider
implements AsyncFileEditorProvider,
DumbAware {
    private static final String EDITOR_TYPE_ID = "org.editorconfig.configmanagement.editor";
    static final int MAX_PREVIEW_LENGTH = 10000;
    private static final PsiAwareTextEditorProvider myMainEditorProvider = new PsiAwareTextEditorProvider();

    @NotNull
    public AsyncFileEditorProvider.Builder createEditorAsync(@NotNull Project project, @NotNull VirtualFile file) {
        return new MyEditorBuilder(project, file);
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)EditorConfigFileType.INSTANCE);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        return new MyEditorBuilder(project, file).build();
    }

    @NotNull
    public String getEditorTypeId() {
        return EDITOR_TYPE_ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    @Nullable
    static Language getLanguage(@NotNull VirtualFile virtualFile) {
        FileType fileType = virtualFile.getFileType();
        return fileType instanceof LanguageFileType ? ((LanguageFileType)fileType).getLanguage() : null;
    }

    private static class MyEditorBuilder
    extends AsyncFileEditorProvider.Builder {
        private final Project myProject;
        private final VirtualFile myFile;

        private MyEditorBuilder(Project project, VirtualFile file) {
            this.myProject = project;
            this.myFile = file;
        }

        public FileEditor build() {
            VirtualFile contextFile = EditorConfigPreviewManager.getInstance(this.myProject).getAssociatedPreviewFile(this.myFile);
            EditorConfigStatusListener statusListener = new EditorConfigStatusListener(this.myProject, this.myFile);
            if (contextFile != null && ((EditorConfigSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(EditorConfigSettings.class)).ENABLED) {
                Document document = EditorFactory.getInstance().createDocument((CharSequence)MyEditorBuilder.getPreviewText(contextFile));
                EditorConfigPreviewFile previewFile = new EditorConfigPreviewFile(this.myProject, contextFile, document);
                FileEditor previewEditor = this.createPreviewEditor(document, previewFile);
                TextEditor ecTextEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(this.myProject, this.myFile);
                EditorConfigEditorWithPreview splitEditor = new EditorConfigEditorWithPreview(this.myFile, this.myProject, ecTextEditor, previewEditor);
                Disposer.register((Disposable)splitEditor, (Disposable)previewFile);
                Disposer.register((Disposable)splitEditor, (Disposable)statusListener);
                return splitEditor;
            }
            FileEditor fileEditor = myMainEditorProvider.createEditor(this.myProject, this.myFile);
            Disposer.register((Disposable)fileEditor, (Disposable)statusListener);
            return fileEditor;
        }

        private FileEditor createPreviewEditor(@NotNull Document document, @NotNull EditorConfigPreviewFile previewFile) {
            Editor previewEditor = EditorFactory.getInstance().createEditor(document, this.myProject);
            if (previewEditor instanceof EditorEx) {
                EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, (VirtualFile)previewFile);
                ((EditorEx)previewEditor).setHighlighter(highlighter);
            }
            return new EditorConfigPreviewFileEditor(previewEditor, previewFile);
        }

        @NotNull
        private static String getPreviewText(@NotNull VirtualFile file) {
            String sample;
            LanguageCodeStyleSettingsProvider provider;
            Language language;
            if (file.getLength() <= 10000L) {
                try {
                    return StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)file));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((language = EditorConfigEditorProvider.getLanguage(file)) != null && (provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)language)) != null && (sample = provider.getCodeSample(LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS)) != null) {
                return sample;
            }
            return "No preview";
        }
    }
}

