/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import javax.swing.JPanel;
import org.editorconfig.language.filetype.EditorConfigFileType;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorConfigEditorNotificationProvider
extends EditorNotifications.Provider<JPanel> {
    private static final Key<JPanel> KEY = Key.create((String)"org.editorconfig.config.management.editor.notification.provider");
    private final Project myProject;

    public EditorConfigEditorNotificationProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Key<JPanel> getKey() {
        return KEY;
    }

    @Nullable
    public JPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (file.getFileType().equals((Object)EditorConfigFileType.INSTANCE) && !((EditorConfigSettings)CodeStyle.getSettings((Project)project).getCustomSettings(EditorConfigSettings.class)).ENABLED) {
            return new MyPanel();
        }
        return null;
    }

    private class MyPanel
    extends EditorNotificationPanel {
        private MyPanel() {
            this.setText(EditorConfigBundle.message("editor.notification.disabled"));
            this.createActionLabel(EditorConfigBundle.message("editor.notification.enable"), () -> {
                ((EditorConfigSettings)CodeStyle.getSettings((Project)((EditorConfigEditorNotificationProvider)EditorConfigEditorNotificationProvider.this).myProject).getCustomSettings(EditorConfigSettings.class)).ENABLED = true;
                CodeStyleSettingsManager.getInstance((Project)EditorConfigEditorNotificationProvider.this.myProject).notifyCodeStyleSettingsChanged();
            });
            this.createActionLabel(EditorConfigBundle.message("editor.notification.open.settings"), () -> ShowSettingsUtil.getInstance().showSettingsDialog(EditorConfigEditorNotificationProvider.this.myProject, IdeBundle.message((String)"configurable.CodeStyle.display.name", (Object[])new Object[0])));
        }
    }
}

