/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.header;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserProvider;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValuePart;

public final class HeaderParserRepository {
    private final ClearableLazyValue<Map<String, HeaderParser>> myParsers = new ClearableLazyValue<Map<String, HeaderParser>>(){

        @NotNull
        protected Map<String, HeaderParser> compute() {
            THashMap map2 = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            for (HeaderParserProvider provider : HeaderParserProvider.EP_NAME.getExtensionList()) {
                map2.putAll(provider.getHeaderParsers());
            }
            return map2;
        }
    };

    public static HeaderParserRepository getInstance() {
        return (HeaderParserRepository)ServiceManager.getService(HeaderParserRepository.class);
    }

    public HeaderParserRepository() {
        HeaderParserProvider.EP_NAME.addChangeListener(() -> this.myParsers.drop(), null);
    }

    @Nullable
    public HeaderParser getHeaderParser(@Nullable String headerName) {
        return (HeaderParser)((Map)this.myParsers.getValue()).get(headerName);
    }

    @NotNull
    public Set<String> getAllHeaderNames() {
        return ((Map)this.myParsers.getValue()).keySet();
    }

    @Nullable
    public Object getConvertedValue(@NotNull Header header) {
        HeaderParser parser = this.getHeaderParser(header.getName());
        return parser != null ? parser.getConvertedValue(header) : null;
    }

    public PsiReference @NotNull [] getReferences(@NotNull HeaderValuePart headerValuePart) {
        HeaderParser parser;
        Header header = (Header)PsiTreeUtil.getParentOfType((PsiElement)headerValuePart, Header.class);
        if (header != null && (parser = this.getHeaderParser(header.getName())) != null) {
            return parser.getReferences(headerValuePart);
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

