/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.template;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.element.FieldElement;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.TemplatesState;

public abstract class TemplatesManager
implements PersistentStateComponent<TemplatesState> {
    public static final Key<Map<String, PsiType>> TEMPLATE_IMPLICITS = Key.create((String)"TEMPLATE_IMPLICITS");
    private TemplatesState myState = new TemplatesState();

    @NotNull
    public abstract List<TemplateResource> getDefaultTemplates();

    protected static String readFile(String resource, Class<? extends TemplatesManager> templatesManagerClass) throws IOException {
        BufferedInputStream in = new BufferedInputStream(templatesManagerClass.getResourceAsStream(resource));
        return StringUtil.convertLineSeparators((String)FileUtil.loadTextAndClose((Reader)new InputStreamReader((InputStream)in, StandardCharsets.UTF_8)));
    }

    @NotNull
    public TemplatesState getState() {
        return this.myState;
    }

    public void loadState(@NotNull TemplatesState state) {
        if (StringUtil.isEmpty((String)state.defaultTemplateName) && !StringUtil.isEmpty((String)state.oldDefaultTemplateName)) {
            state.defaultTemplateName = state.oldDefaultTemplateName;
        }
        state.oldDefaultTemplateName = null;
        this.myState = state;
    }

    public void addTemplate(@NotNull TemplateResource template) {
        this.myState.templates.add(template);
    }

    @NotNull
    public Collection<TemplateResource> getAllTemplates() {
        HashSet<String> names2 = new HashSet<String>();
        LinkedHashSet<TemplateResource> templates = new LinkedHashSet<TemplateResource>(this.getDefaultTemplates());
        for (TemplateResource template : this.myState.templates) {
            if (!names2.add(template.getFileName())) continue;
            templates.add(template);
        }
        return templates;
    }

    public TemplateResource getDefaultTemplate() {
        TemplateResource resource = this.findTemplateByName(this.myState.defaultTemplateName);
        if (resource != null) {
            return resource;
        }
        String initialTemplateName = this.getInitialTemplateName();
        TemplateResource templateResource = resource = initialTemplateName != null ? this.findTemplateByName(initialTemplateName) : null;
        if (resource == null) {
            return this.getAllTemplates().iterator().next();
        }
        return resource;
    }

    protected String getInitialTemplateName() {
        return null;
    }

    @Nullable
    public TemplateResource findTemplateByName(String templateName) {
        for (TemplateResource template : this.getAllTemplates()) {
            if (!Objects.equals(template.getFileName(), templateName)) continue;
            return template;
        }
        return null;
    }

    public void setDefaultTemplate(@NotNull TemplateResource resource) {
        this.myState.defaultTemplateName = resource.getFileName();
    }

    public void setTemplates(@NotNull List<? extends TemplateResource> items) {
        this.myState.templates.clear();
        for (TemplateResource templateResource : items) {
            if (templateResource.isDefault()) continue;
            this.myState.templates.add(templateResource);
        }
    }

    @NotNull
    public static PsiType createFieldListElementType(@NotNull Project project) {
        PsiClass[] classes2;
        PsiType classType = TemplatesManager.createElementType(project, FieldElement.class);
        for (PsiClass listClass : classes2 = JavaPsiFacade.getInstance((Project)project).findClasses("java.util.List", GlobalSearchScope.allScope((Project)project))) {
            if (listClass.getTypeParameters().length != 1) continue;
            return JavaPsiFacade.getElementFactory((Project)project).createType(listClass, classType);
        }
        return PsiType.NULL;
    }

    @NotNull
    public static PsiType createElementType(Project project, Class<?> elementClass) {
        List methodNames = ContainerUtil.mapNotNull((Object[])elementClass.getMethods(), method -> {
            String methodName = method.getName();
            if (methodName.startsWith("set") || method.isSynthetic() || method.isBridge()) {
                return null;
            }
            String parametersString2 = StringUtil.join((Object[])method.getParameters(), param -> param.getParameterizedType().getTypeName() + " " + param.getName(), (String)", ");
            return method.getGenericReturnType().getTypeName() + " " + methodName + "(" + parametersString2 + ");";
        });
        String text2 = "interface " + elementClass.getSimpleName() + " {\n" + StringUtil.join((Collection)methodNames, (String)"\n") + "}";
        PsiClass aClass = JavaPsiFacade.getElementFactory((Project)project).createClassFromText(text2, null).getInnerClasses()[0];
        return JavaPsiFacade.getElementFactory((Project)project).createType(aClass);
    }
}

