/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.config;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.config.InsertNewMethodStrategy;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class InsertLastStrategy
implements InsertNewMethodStrategy {
    private static final InsertLastStrategy instance = new InsertLastStrategy();

    private InsertLastStrategy() {
    }

    public static InsertLastStrategy getInstance() {
        return instance;
    }

    @Override
    public PsiMethod insertNewMethod(PsiClass clazz, @NotNull PsiMethod newMethod, Editor editor) {
        PsiMethod[] methods;
        PsiMethod mainMethod = PsiAdapter.findPublicStaticVoidMainMethod(clazz);
        if (mainMethod != null && mainMethod.equals((methods = clazz.getMethods())[methods.length - 1])) {
            return (PsiMethod)clazz.addBefore((PsiElement)newMethod, (PsiElement)mainMethod);
        }
        PsiElement last = clazz.getRBrace();
        return (PsiMethod)clazz.addBefore((PsiElement)newMethod, last);
    }

    public String toString() {
        return "Last";
    }
}

