/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEditorsProvider
extends XDebuggerEditorsProviderBase {
    @NotNull
    public FileType getFileType() {
        return JavaFileType.INSTANCE;
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull String text2, @Nullable PsiElement context, boolean isPhysical) {
        return JavaCodeFragmentFactory.getInstance((Project)project).createExpressionCodeFragment(text2, context, null, isPhysical);
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@Nullable PsiElement context) {
        return ContainerUtil.map(DebuggerUtilsEx.getCodeFragmentFactories(context), factory -> factory.getFileType().getLanguage());
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project, @Nullable XSourcePosition sourcePosition) {
        if (sourcePosition != null) {
            return this.getSupportedLanguages(this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project));
        }
        return Collections.emptyList();
    }

    @NotNull
    public XExpression createExpression(@NotNull Project project, @NotNull Document document, @Nullable Language language, @NotNull EvaluationMode mode) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile instanceof JavaCodeFragment) {
            return new XExpressionImpl(document.getText(), language, StringUtil.nullize((String)((JavaCodeFragment)psiFile).importsToString()), mode);
        }
        return super.createExpression(project, document, language, mode);
    }

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull XExpression expression2, @Nullable PsiElement context, boolean isPhysical) {
        TextWithImports text2 = TextWithImportsImpl.fromXExpression(expression2);
        if (text2 != null) {
            CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(text2, context);
            JavaCodeFragment codeFragment = factory.createPresentationCodeFragment(text2, context, project);
            if (context != null) {
                PsiClass contextClass;
                PsiType contextType = (PsiType)context.getUserData(DebuggerUtilsImpl.PSI_TYPE_KEY);
                if (contextType == null && (contextClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiClass.class})) != null) {
                    contextType = JavaPsiFacade.getElementFactory((Project)codeFragment.getProject()).createType(contextClass);
                }
                codeFragment.setThisType(contextType);
            }
            return codeFragment;
        }
        return super.createExpressionCodeFragment(project, expression2, context, isPhysical);
    }
}

