/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailExceptionsPredicate
implements PsiElementPredicate {
    DetailExceptionsPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiTryStatement tryStatement = (PsiTryStatement)ObjectUtils.chooseNotNull((Object)DetailExceptionsPredicate.getTryStatementIfKeyword(element), (Object)DetailExceptionsPredicate.getTryStatementIfParameter(element));
        if (tryStatement == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        Set<PsiClassType> exceptionsThrown = ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock);
        ExceptionUtils.calculateExceptionsThrown((PsiElement)tryStatement.getResourceList(), exceptionsThrown);
        Set<PsiType> exceptionsCaught = ExceptionUtils.getExceptionTypesHandled(tryStatement);
        for (PsiType psiType : exceptionsThrown) {
            if (exceptionsCaught.contains(psiType)) continue;
            for (PsiType typeCaught : exceptionsCaught) {
                if (!typeCaught.isAssignableFrom(psiType)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiTryStatement getTryStatementIfParameter(@NotNull PsiElement element) {
        PsiParameter parameter2 = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class);
        if (parameter2 == null) {
            return null;
        }
        PsiCatchSection catchSection = (PsiCatchSection)ObjectUtils.tryCast((Object)parameter2.getParent(), PsiCatchSection.class);
        if (catchSection == null) {
            return null;
        }
        return (PsiTryStatement)ObjectUtils.tryCast((Object)catchSection.getParent(), PsiTryStatement.class);
    }

    @Nullable
    private static PsiTryStatement getTryStatementIfKeyword(@NotNull PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return null;
        }
        IElementType tokenType = ((PsiJavaToken)element).getTokenType();
        if (!JavaTokenType.TRY_KEYWORD.equals(tokenType) && !JavaTokenType.CATCH_KEYWORD.equals(tokenType)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCatchSection) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiTryStatement)) {
            return null;
        }
        return (PsiTryStatement)parent;
    }
}

