/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.ConvertCatchToThrowsPredicate;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConvertCatchToThrowsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ConvertCatchToThrowsPredicate();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiMethod method;
        PsiCatchSection catchSection = (PsiCatchSection)element.getParent();
        NavigatablePsiElement owner2 = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)catchSection, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (owner2 instanceof PsiMethod) {
            method = (PsiMethod)owner2;
        } else if (owner2 instanceof PsiLambdaExpression) {
            method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)owner2);
        } else {
            return;
        }
        if (method == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{method})) {
            return;
        }
        WriteAction.run(() -> {
            ConvertCatchToThrowsIntention.addToThrowsList(method.getThrowsList(), catchSection.getCatchType());
            PsiTryStatement tryStatement = catchSection.getTryStatement();
            if (tryStatement.getCatchSections().length > 1 || tryStatement.getResourceList() != null || tryStatement.getFinallyBlock() != null) {
                catchSection.delete();
            } else {
                BlockUtils.unwrapTryBlock(tryStatement);
            }
        });
    }

    private static void addToThrowsList(PsiReferenceList throwsList, PsiType catchType) {
        if (catchType instanceof PsiClassType) {
            PsiClassType[] types;
            PsiClassType classType = (PsiClassType)catchType;
            for (PsiClassType type2 : types = throwsList.getReferencedTypes()) {
                if (!catchType.equals(type2)) continue;
                return;
            }
            Project project = throwsList.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(classType);
            throwsList.add((PsiElement)referenceElement);
        } else if (catchType instanceof PsiDisjunctionType) {
            PsiDisjunctionType disjunctionType = (PsiDisjunctionType)catchType;
            List disjunctions = disjunctionType.getDisjunctions();
            for (PsiType disjunction : disjunctions) {
                ConvertCatchToThrowsIntention.addToThrowsList(throwsList, disjunction);
            }
        }
    }
}

