/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.ui;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.OrderedSet;
import java.util.Collections;
import java.util.Iterator;
import org.jdom.Element;

public class ExternalizableStringSet
extends OrderedSet<String>
implements JDOMExternalizable {
    private static final String ITEM = "item";
    private static final String VALUE = "value";
    private final String[] defaultValues;

    public ExternalizableStringSet(String ... defaultValues) {
        this.defaultValues = defaultValues.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : defaultValues;
        Collections.addAll(this, defaultValues);
    }

    public boolean hasDefaultValues() {
        if (this.size() != this.defaultValues.length) {
            return false;
        }
        for (String defaultValue : this.defaultValues) {
            if (this.contains(defaultValue)) continue;
            return false;
        }
        return true;
    }

    public void readExternal(Element element) throws InvalidDataException {
        boolean dataFound = false;
        for (Element item : element.getChildren(ITEM)) {
            String value2;
            if (!dataFound) {
                this.clear();
                dataFound = true;
            }
            this.add((value2 = item.getAttributeValue(VALUE)) == null ? null : StringUtil.unescapeXmlEntities((String)value2));
        }
    }

    public void writeExternal(Element element) {
        if (this.hasDefaultValues()) {
            return;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            String value2 = (String)iterator.next();
            if (value2 == null) continue;
            Element item = new Element(ITEM);
            item.setAttribute(VALUE, StringUtil.escapeXmlEntities((String)value2));
            element.addContent(item);
        }
    }

    public void writeSettings(Element element, String name2) {
        if (this.hasDefaultValues()) {
            return;
        }
        Element optionElement = new Element("option").setAttribute("name", name2);
        Element valueElement = new Element(VALUE);
        this.writeExternal(valueElement);
        element.addContent(optionElement.addContent(valueElement));
    }
}

