/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SynchronizeOnNonFinalFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("synchronize.on.non.final.field.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldFinalFix.buildFix(field);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnNonFinalFieldVisitor();
    }

    private static class SynchronizeOnNonFinalFieldVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnNonFinalFieldVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getLockExpression());
            if (!(lockExpression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement element = ((PsiReferenceExpression)lockExpression2).resolve();
            if (!(element instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)element;
            if (field.hasModifierProperty("final")) {
                return;
            }
            this.registerError((PsiElement)lockExpression2, field);
        }
    }
}

