/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryQualifierForThisInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message(infos[0] instanceof PsiThisExpression ? "unnecessary.qualifier.for.this.problem.descriptor" : "unnecessary.qualifier.for.super.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryQualifierForThisVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryQualifierForThisFix();
    }

    private static class UnnecessaryQualifierForThisVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryQualifierForThisVisitor() {
        }

        public void visitThisExpression(@NotNull PsiThisExpression thisExpression) {
            super.visitThisExpression(thisExpression);
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement referent = qualifier.resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)thisExpression);
            if (containingClass == null || !containingClass.equals(referent)) {
                return;
            }
            this.registerError((PsiElement)qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{thisExpression});
        }

        public void visitSuperExpression(PsiSuperExpression expression2) {
            super.visitSuperExpression(expression2);
            PsiJavaCodeReferenceElement qualifier = expression2.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement resolve2 = qualifier.resolve();
            if (!(resolve2 instanceof PsiClass)) {
                return;
            }
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiReferenceExpression) {
                PsiElement gParent = parent.getParent();
                PsiReferenceExpression copy = gParent instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)gParent.copy()).getMethodExpression() : (PsiReferenceExpression)parent.copy();
                PsiExpression copyQualifierExpression = copy.getQualifierExpression();
                assert (copyQualifierExpression != null);
                PsiReplacementUtil.replaceExpression(copyQualifierExpression, "super");
                if (copy.resolve() == ((PsiReferenceExpression)parent).resolve()) {
                    this.registerError((PsiElement)qualifier, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{expression2});
                }
            }
        }
    }

    private static class UnnecessaryQualifierForThisFix
    extends InspectionGadgetsFix {
        private UnnecessaryQualifierForThisFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement qualifier = descriptor.getPsiElement();
            PsiElement parent = qualifier.getParent();
            CommentTracker tracker = new CommentTracker();
            if (parent instanceof PsiThisExpression) {
                PsiReplacementUtil.replaceExpression((PsiExpression)((PsiThisExpression)parent), "this", tracker);
            } else if (parent instanceof PsiSuperExpression) {
                PsiReplacementUtil.replaceExpression((PsiExpression)((PsiSuperExpression)parent), "super", tracker);
            }
        }
    }
}

