/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryEnumModifierInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiElement parent = (PsiElement)infos[1];
        if (parent instanceof PsiMethod) {
            return InspectionGadgetsBundle.message("unnecessary.enum.modifier.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("unnecessary.enum.modifier.problem.descriptor1", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryEnumModifierVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryEnumModifierFix((PsiElement)infos[0]);
    }

    private static class UnnecessaryEnumModifierVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryEnumModifierVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement[] children;
            if (!(aClass.isEnum() && ClassUtils.isInnerClass(aClass) && aClass.hasModifierProperty("static"))) {
                return;
            }
            PsiModifierList modifiers = aClass.getModifierList();
            if (modifiers == null) {
                return;
            }
            for (PsiElement child : children = modifiers.getChildren()) {
                String text2 = child.getText();
                if (!"static".equals(text2)) continue;
                this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{child, aClass});
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiElement[] children;
            if (!method.isConstructor() || !method.hasModifierProperty("private")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || !aClass.isEnum()) {
                return;
            }
            PsiModifierList modifiers = method.getModifierList();
            for (PsiElement child : children = modifiers.getChildren()) {
                String text2 = child.getText();
                if (!"private".equals(text2)) continue;
                this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{child, method});
            }
        }
    }

    private static class UnnecessaryEnumModifierFix
    extends InspectionGadgetsFix {
        private final String m_name;

        UnnecessaryEnumModifierFix(PsiElement modifier) {
            this.m_name = InspectionGadgetsBundle.message("smth.unnecessary.remove.quickfix", modifier.getText());
        }

        @NotNull
        public String getName() {
            return this.m_name;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.interface.modifiers.fix.family.name", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiModifierList modifierList = (PsiModifierList)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiModifierList.class});
            if (modifierList == null) {
                return;
            }
            modifierList.setModifierProperty(modifierList.getParent() instanceof PsiClass ? "static" : "private", false);
        }
    }
}

