/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringBufferReplaceableByStringInspection
extends BaseInspection {
    static final String STRING_JOINER = "java.util.StringJoiner";
    private static final CallMatcher STRING_JOINER_ADD = CallMatcher.instanceCall("java.util.StringJoiner", "add").parameterCount(1);

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String typeText = ((PsiType)infos[1]).getPresentableText();
        return new StringBufferReplaceableByStringFix(typeText);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiElement element = (PsiElement)infos[0];
        if (element instanceof PsiNewExpression) {
            return InspectionGadgetsBundle.message("new.string.buffer.replaceable.by.string.problem.descriptor", new Object[0]);
        }
        String typeText = ((PsiType)infos[1]).getPresentableText();
        return InspectionGadgetsBundle.message("string.buffer.replaceable.by.string.problem.descriptor", typeText);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferReplaceableByStringVisitor();
    }

    static boolean isConcatenatorConstruction(PsiNewExpression expression2) {
        PsiType type2 = expression2.getType();
        if (TypeUtils.typeEquals("java.lang.StringBuffer", type2) || TypeUtils.typeEquals("java.lang.StringBuilder", type2)) {
            return true;
        }
        if (TypeUtils.typeEquals(STRING_JOINER, type2)) {
            PsiExpressionList args = expression2.getArgumentList();
            if (args == null) {
                return false;
            }
            PsiExpression[] expressions2 = args.getExpressions();
            return expressions2.length == 1 && ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)expressions2[0]), "");
        }
        return false;
    }

    static boolean isConcatenatorType(PsiType type2) {
        return TypeUtils.typeEquals("java.lang.StringBuffer", type2) || TypeUtils.typeEquals("java.lang.StringBuilder", type2) || TypeUtils.typeEquals(STRING_JOINER, type2);
    }

    static boolean isAppendCall(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        if (STRING_JOINER_ADD.test(methodCallExpression)) {
            return true;
        }
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"append".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 3) {
            return (arguments[0].getType() instanceof PsiArrayType || TypeUtils.isJavaLangString(arguments[0].getType())) && PsiType.INT.equals((Object)arguments[1].getType()) && PsiType.INT.equals((Object)arguments[2].getType());
        }
        return arguments.length == 1;
    }

    static boolean isToStringCall(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"toString".equals(methodName)) {
            return false;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        return arguments.length == 0;
    }

    @Nullable
    static PsiExpression getCompleteExpression(PsiExpression qualifier) {
        while (!ExpressionUtils.isImplicitToStringCall(qualifier)) {
            PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier(qualifier);
            if (call == null) {
                return null;
            }
            if (StringBufferReplaceableByStringInspection.isToStringCall((PsiElement)call)) {
                return call;
            }
            if (!StringBufferReplaceableByStringInspection.isAppendCall((PsiElement)call)) {
                return null;
            }
            qualifier = call;
        }
        return qualifier;
    }

    private static class ReplaceableByStringVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiElement myParent;
        private final PsiVariable myVariable;
        private boolean myReplaceable = true;
        private boolean myPossibleSideEffect;
        private boolean myToStringFound;

        ReplaceableByStringVisitor(@NotNull PsiVariable variable) {
            this.myVariable = variable;
            this.myParent = PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiCodeBlock.class, PsiIfStatement.class, PsiLoopStatement.class});
        }

        public boolean isReplaceable() {
            return this.myReplaceable && this.myToStringFound;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (!this.myReplaceable) {
                return;
            }
            super.visitElement(element);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            if (expression2.getTextOffset() > this.myVariable.getTextOffset() && !this.myToStringFound) {
                this.myPossibleSideEffect = true;
            }
        }

        public void visitUnaryExpression(PsiUnaryExpression expression2) {
            super.visitUnaryExpression(expression2);
            if (expression2.getTextOffset() > this.myVariable.getTextOffset() && !this.myToStringFound) {
                this.myPossibleSideEffect = true;
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (expression2.getTextOffset() < this.myVariable.getTextOffset() || this.myToStringFound) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                this.myPossibleSideEffect = true;
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                this.myPossibleSideEffect = true;
                return;
            }
            String name2 = aClass.getQualifiedName();
            if ("java.lang.StringBuffer".equals(name2) || "java.lang.StringBuilder".equals(name2) || StringBufferReplaceableByStringInspection.STRING_JOINER.equals(name2)) {
                return;
            }
            if (this.isArgumentOfStringBuilderMethod(expression2)) {
                return;
            }
            this.myPossibleSideEffect = true;
        }

        private boolean isArgumentOfStringBuilderMethod(PsiMethodCallExpression expression2) {
            PsiExpressionList parent = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpressionList.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            if (parent == null) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                return this.isCallToStringBuilderMethod(methodCallExpression) || this.isArgumentOfStringBuilderMethod(methodCallExpression);
            }
            if (grandParent instanceof PsiNewExpression) {
                PsiLocalVariable variable = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)grandParent, PsiLocalVariable.class, (boolean)true, (Class[])new Class[]{PsiExpressionList.class});
                if (!this.myVariable.equals(variable)) {
                    return false;
                }
                PsiNewExpression newExpression = (PsiNewExpression)grandParent;
                PsiMethod constructor = newExpression.resolveMethod();
                if (constructor == null) {
                    return false;
                }
                PsiClass aClass = constructor.getContainingClass();
                if (aClass == null) {
                    return false;
                }
                String name2 = aClass.getQualifiedName();
                return "java.lang.StringBuffer".equals(name2) || "java.lang.StringBuilder".equals(name2);
            }
            return false;
        }

        private boolean isCallToStringBuilderMethod(PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpression.getQualifierExpression());
            while (qualifier instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)qualifier;
                qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!this.myVariable.equals(target)) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String name1 = aClass.getQualifiedName();
            return "java.lang.StringBuffer".equals(name1) || "java.lang.StringBuilder".equals(name1);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiElement grandParent;
            if (!this.myReplaceable || expression2.getTextOffset() < this.myVariable.getTextOffset()) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiExpression qualifier = expression2.getQualifierExpression();
            if (qualifier != null || !expression2.isReferenceTo((PsiElement)this.myVariable)) {
                return;
            }
            if (this.myToStringFound) {
                this.myReplaceable = false;
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiCodeBlock.class, PsiIfStatement.class, PsiLoopStatement.class});
            if (this.myParent != element) {
                this.myReplaceable = false;
                return;
            }
            if (ExpressionUtils.isImplicitToStringCall((PsiExpression)expression2)) {
                this.myToStringFound = true;
                return;
            }
            PsiElement parent = expression2.getParent();
            do {
                if (!(parent instanceof PsiReferenceExpression)) {
                    this.myReplaceable = false;
                    return;
                }
                grandParent = parent.getParent();
                if (!StringBufferReplaceableByStringInspection.isAppendCall(grandParent)) {
                    if (!StringBufferReplaceableByStringInspection.isToStringCall(grandParent)) {
                        this.myReplaceable = false;
                        return;
                    }
                    this.myToStringFound = true;
                    return;
                }
                if (!this.myPossibleSideEffect) continue;
                this.myReplaceable = false;
                return;
            } while (!((parent = grandParent.getParent()) instanceof PsiExpressionStatement));
        }
    }

    private static class StringBufferReplaceableByStringVisitor
    extends BaseInspectionVisitor {
        private StringBufferReplaceableByStringVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            PsiType type2 = variable.getType();
            if (!StringBufferReplaceableByStringInspection.isConcatenatorType(type2)) {
                return;
            }
            PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
            if (!StringBufferReplaceableByStringVisitor.isNewStringConcatenatorChain(initializer)) {
                return;
            }
            PsiElement codeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
            if (codeBlock == null) {
                return;
            }
            ReplaceableByStringVisitor visitor2 = new ReplaceableByStringVisitor((PsiVariable)variable);
            codeBlock.accept((PsiElementVisitor)visitor2);
            if (!visitor2.isReplaceable()) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, variable, type2);
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!StringBufferReplaceableByStringInspection.isConcatenatorConstruction(expression2)) {
                return;
            }
            PsiExpression completeExpression = StringBufferReplaceableByStringInspection.getCompleteExpression((PsiExpression)expression2);
            if (completeExpression == null) {
                return;
            }
            this.registerNewExpressionError(expression2, expression2, type2);
        }

        private static boolean isNewStringConcatenatorChain(PsiExpression expression2) {
            while (expression2 != null) {
                if (expression2 instanceof PsiNewExpression) {
                    return StringBufferReplaceableByStringInspection.isConcatenatorConstruction((PsiNewExpression)expression2);
                }
                if (!(expression2 instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
                if (!StringBufferReplaceableByStringInspection.isAppendCall((PsiElement)call)) {
                    return false;
                }
                expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
            }
            return false;
        }
    }

    private static class StringBufferReplaceableByStringFix
    extends InspectionGadgetsFix {
        private final String myType;
        private int currentLine = -1;

        StringBufferReplaceableByStringFix(String type2) {
            this.myType = type2;
        }

        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.myType, "String"});
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"String"});
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            boolean useVariable;
            PsiCodeBlock codeBlock;
            StringBuilder builder;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiVariable)) {
                CommentTracker tracker;
                StringBuilder stringExpression;
                PsiExpression stringBuilderExpression;
                if (parent instanceof PsiNewExpression && (stringBuilderExpression = StringBufferReplaceableByStringInspection.getCompleteExpression((PsiExpression)parent)) != null && (stringExpression = this.buildStringExpression((PsiElement)stringBuilderExpression, tracker = new CommentTracker(), new StringBuilder())) != null) {
                    String replacement = StringBufferReplaceableByStringFix.addConversionToStringIfNecessary((PsiElement)stringBuilderExpression, stringExpression.toString());
                    tracker.replaceExpressionAndRestoreComments(stringBuilderExpression, replacement);
                }
                return;
            }
            PsiVariable variable = (PsiVariable)parent;
            String variableName2 = variable.getName();
            if (variableName2 == null) {
                return;
            }
            PsiTypeElement originalTypeElement = variable.getTypeElement();
            if (originalTypeElement == null) {
                return;
            }
            PsiExpression initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer());
            if (initializer == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            if (StringBufferReplaceableByStringInspection.isAppendCall((PsiElement)initializer)) {
                builder = this.buildStringExpression((PsiElement)initializer, tracker, new StringBuilder());
                if (builder == null) {
                    return;
                }
            } else if (initializer instanceof PsiNewExpression) {
                Object argument;
                PsiNewExpression newExpression = (PsiNewExpression)initializer;
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                PsiExpression[] arguments = argumentList.getExpressions();
                builder = arguments.length == 0 || TypeUtils.typeEquals(StringBufferReplaceableByStringInspection.STRING_JOINER, newExpression.getType()) ? new StringBuilder() : (PsiType.INT.equals((Object)(argument = arguments[0]).getType()) ? new StringBuilder() : (ParenthesesUtils.getPrecedence((PsiExpression)argument) > 6 ? new StringBuilder("(").append(tracker.text((PsiElement)argument)).append(')') : new StringBuilder(tracker.text((PsiElement)argument))));
            } else {
                return;
            }
            if ((codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)) == null) {
                return;
            }
            StringExpressionCollector visitor2 = new StringExpressionCollector(variable);
            codeBlock.accept((PsiElementVisitor)visitor2);
            List<PsiExpression> expressions2 = visitor2.getExpressions();
            for (PsiExpression expression2 : expressions2) {
                if (expression2 != null && this.buildStringExpression((PsiElement)expression2, tracker, builder) != null) continue;
                return;
            }
            String expressionText = StringBufferReplaceableByStringFix.addConversionToStringIfNecessary(element, builder.toString());
            PsiExpression lastExpression = expressions2.get(expressions2.size() - 1);
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)lastExpression, PsiStatement.class);
            if (statement == null) {
                return;
            }
            SmartList toDelete = new SmartList();
            toDelete.add(variable);
            int size = expressions2.size() - 1;
            for (int i = 0; i < size; ++i) {
                toDelete.add(expressions2.get(i).getParent());
            }
            boolean bl = useVariable = expressionText.contains("\n") && !StringBufferReplaceableByStringFix.isVariableInitializer(lastExpression);
            if (useVariable) {
                toDelete.forEach(tracker::delete);
                String modifier = JavaCodeStyleSettings.getInstance((PsiFile)lastExpression.getContainingFile()).GENERATE_FINAL_LOCALS ? "final " : "";
                String statementText = modifier + "java.lang.String" + ' ' + variableName2 + "=" + expressionText + ';';
                PsiStatement newStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(statementText, (PsiElement)lastExpression);
                codeBlock.addBefore((PsiElement)newStatement, (PsiElement)statement);
                PsiReplacementUtil.replaceExpression(lastExpression, variableName2, tracker);
            } else {
                tracker.replaceExpressionAndRestoreComments(lastExpression, expressionText, (List<? extends PsiElement>)toDelete);
            }
        }

        @NotNull
        private static String addConversionToStringIfNecessary(PsiElement context, String concatText) {
            concatText = concatText.trim();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
            PsiExpression expression2 = factory.createExpressionFromText(concatText, context);
            PsiPolyadicExpression concat = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)expression2, PsiPolyadicExpression.class);
            if (concat != null && concat.getOperationTokenType().equals(JavaTokenType.PLUS)) {
                PsiExpression[] operands2 = concat.getOperands();
                if (operands2[0] != null && !TypeUtils.isJavaLangString(operands2[0].getType()) && !TypeUtils.isJavaLangString(operands2[1].getType())) {
                    operands2[0].replace((PsiElement)factory.createExpressionFromText(StringBufferReplaceableByStringFix.convertToString(operands2[0]), context));
                    return concat.getText();
                }
            } else if (!TypeUtils.isJavaLangString(expression2.getType())) {
                return StringBufferReplaceableByStringFix.convertToString(expression2);
            }
            return concatText;
        }

        @NotNull
        private static String convertToString(PsiExpression expression2) {
            PsiType type2 = expression2.getType();
            PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
            if (stripped != null) {
                expression2 = stripped;
            }
            if (type2 instanceof PsiPrimitiveType && expression2 instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
                Object value2 = literalExpression.getValue();
                if (value2 instanceof Character) {
                    return '\"' + StringUtil.escapeStringCharacters((String)value2.toString()) + '\"';
                }
                return "\"" + value2 + '\"';
            }
            return "String.valueOf(" + expression2.getText() + ")";
        }

        private static boolean isVariableInitializer(PsiExpression expression2) {
            PsiElement parent = expression2.getParent();
            if (!(parent instanceof PsiVariable)) {
                return false;
            }
            PsiVariable variable = (PsiVariable)parent;
            PsiExpression initializer = variable.getInitializer();
            return initializer == expression2;
        }

        @Nullable
        StringBuilder buildStringExpression(@NotNull PsiElement element, @NotNull CommentTracker tracker, @NonNls StringBuilder result) {
            if (this.currentLine < 0) {
                this.currentLine = StringBufferReplaceableByStringFix.getLineNumber(element);
            }
            if (element instanceof PsiNewExpression) {
                PsiExpression argument;
                PsiType type2;
                PsiNewExpression newExpression = (PsiNewExpression)element;
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList == null) {
                    return null;
                }
                this.appendFormattedPlusIfNeeded((PsiElement)argumentList, result, "");
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length == 1 && !TypeUtils.typeEquals(StringBufferReplaceableByStringInspection.STRING_JOINER, newExpression.getType()) && !PsiType.INT.equals((Object)(type2 = (argument = arguments[0]).getType()))) {
                    if (type2 != null && type2.equalsToText("java.lang.CharSequence")) {
                        result.append("String.valueOf(").append(tracker.textWithComments((PsiElement)argument)).append(')');
                    } else {
                        result.append(tracker.textWithComments(argument, 6));
                    }
                }
                return result;
            }
            for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof PsiExpressionList || this.buildStringExpression(child, tracker, result) != null) continue;
                return null;
            }
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String referenceName = methodExpression.getReferenceName();
                if ("toString".equals(referenceName)) {
                    if (result.length() == 0) {
                        result.append("\"\"");
                    }
                } else if ("append".equals(referenceName) || "add".equals(referenceName)) {
                    PsiExpression[] arguments;
                    String commentsBefore = "";
                    ASTNode dot = ((CompositeElement)methodExpression.getNode()).findChildByRole(55);
                    if (dot != null && result.length() > 0) {
                        commentsBefore = tracker.commentsBefore(dot.getPsi());
                    }
                    if ((arguments = argumentList.getExpressions()).length == 0) {
                        return null;
                    }
                    if (arguments.length == 3) {
                        PsiExpression firstArg = arguments[0];
                        this.appendFormattedPlusIfNeeded((PsiElement)argumentList, result, commentsBefore);
                        if (TypeUtils.isJavaLangString(firstArg.getType())) {
                            result.append(tracker.textWithComments(firstArg, 1)).append(".substring(").append(tracker.textWithComments((PsiElement)arguments[1])).append(",").append(tracker.textWithComments((PsiElement)arguments[2])).append(")");
                        } else {
                            result.append("String.valueOf").append(tracker.textWithComments((PsiElement)argumentList));
                        }
                        return result;
                    }
                    PsiExpression argument = arguments[0];
                    PsiType type3 = argument.getType();
                    String argumentText = tracker.textWithComments((PsiElement)argument);
                    this.appendFormattedPlusIfNeeded((PsiElement)argument, result, commentsBefore);
                    if (ParenthesesUtils.getPrecedence(argument) > 6 || type3 instanceof PsiPrimitiveType && ParenthesesUtils.getPrecedence(argument) == 6) {
                        result.append('(').append(argumentText).append(')');
                    } else if (type3 instanceof PsiArrayType) {
                        result.append("String.valueOf(").append(argumentText).append(')');
                    } else {
                        if (StringUtil.startsWithChar((CharSequence)argumentText, (char)'+')) {
                            result.append(' ');
                        }
                        result.append(argumentText);
                    }
                }
            }
            if (element instanceof PsiExpression && ExpressionUtils.isImplicitToStringCall((PsiExpression)element) && result.length() == 0) {
                result.append("\"\"");
            }
            return result;
        }

        private void appendFormattedPlusIfNeeded(PsiElement anchor, StringBuilder out, String commentsBefore) {
            boolean notEmpty;
            boolean operationSignOnNextLine = CodeStyle.getLanguageSettings((PsiFile)anchor.getContainingFile(), (Language)JavaLanguage.INSTANCE).BINARY_OPERATION_SIGN_ON_NEXT_LINE;
            int lineNumber = StringBufferReplaceableByStringFix.getLineNumber(anchor);
            boolean insertNewLine = this.currentLine != lineNumber;
            boolean bl = notEmpty = out.length() > 0;
            if (notEmpty && !operationSignOnNextLine) {
                out.append(insertNewLine ? '+' + commentsBefore : commentsBefore + '+');
            } else {
                out.append(commentsBefore);
            }
            if (insertNewLine && notEmpty && !StringBufferReplaceableByStringFix.hasTrailingLineBreak(out)) {
                out.append("\n ");
            }
            if (notEmpty && operationSignOnNextLine) {
                out.append('+');
            }
            this.currentLine = lineNumber;
        }

        private static boolean hasTrailingLineBreak(StringBuilder sb) {
            for (int i = sb.length() - 1; i >= 0; --i) {
                if (sb.charAt(i) == '\n') {
                    return true;
                }
                if (Character.isWhitespace(sb.charAt(i))) continue;
                return false;
            }
            return false;
        }

        private static int getLineNumber(PsiElement element) {
            Document document = element.getContainingFile().getViewProvider().getDocument();
            assert (document != null);
            return document.getLineNumber(element.getTextRange().getStartOffset());
        }

        private static class StringExpressionCollector
        extends JavaRecursiveElementWalkingVisitor {
            private final PsiVariable myVariable;
            private final List<PsiExpression> myExpressions = new SmartList();

            StringExpressionCollector(@NotNull PsiVariable variable) {
                this.myVariable = variable;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression2.resolve();
                if (!this.myVariable.equals(target)) {
                    return;
                }
                if (ExpressionUtils.isImplicitToStringCall((PsiExpression)expression2)) {
                    this.myExpressions.add((PsiExpression)expression2);
                } else {
                    PsiMethodCallExpression methodCallExpression = null;
                    PsiElement parent = expression2.getParent();
                    PsiElement grandParent = parent.getParent();
                    while (parent instanceof PsiReferenceExpression && grandParent instanceof PsiMethodCallExpression) {
                        methodCallExpression = (PsiMethodCallExpression)grandParent;
                        parent = methodCallExpression.getParent();
                        grandParent = parent.getParent();
                        if (!"toString".equals(methodCallExpression.getMethodExpression().getReferenceName())) continue;
                    }
                    this.myExpressions.add((PsiExpression)methodCallExpression);
                }
            }

            public List<PsiExpression> getExpressions() {
                return this.myExpressions;
            }
        }
    }
}

