/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.NormalizeDeclarationFix;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class MultipleVariablesInDeclarationInspection
extends BaseInspection {
    public boolean ignoreForLoopDeclarations = true;
    public boolean onlyWarnArrayDimensions = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "MultipleVariablesInDeclaration";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.onlyWarnArrayDimensions ? InspectionGadgetsBundle.message("multiple.typed.declaration.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("multiple.declaration.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("multiple.declaration.ignore.for.option", new Object[0]), "ignoreForLoopDeclarations");
        panel2.addCheckbox(InspectionGadgetsBundle.message("multiple.declaration.array.only.option", new Object[0]), "onlyWarnArrayDimensions");
        return panel2;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new NormalizeDeclarationFix(false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleDeclarationVisitor();
    }

    private class MultipleDeclarationVisitor
    extends BaseInspectionVisitor {
        MultipleDeclarationVisitor() {
        }

        public void visitDeclarationStatement(PsiDeclarationStatement statement) {
            ProblemHighlightType highlightType;
            super.visitDeclarationStatement(statement);
            PsiElement[] declaredElements = statement.getDeclaredElements();
            if (declaredElements.length < 2) {
                return;
            }
            PsiElement parent = statement.getParent();
            if (MultipleVariablesInDeclarationInspection.this.ignoreForLoopDeclarations && parent instanceof PsiForStatement) {
                highlightType = ProblemHighlightType.INFORMATION;
            } else if (MultipleVariablesInDeclarationInspection.this.onlyWarnArrayDimensions) {
                PsiVariable variable = (PsiVariable)declaredElements[0];
                PsiType baseType = variable.getType();
                boolean hasMultipleTypes = false;
                for (int i = 1; i < declaredElements.length; ++i) {
                    PsiType variableType = ((PsiLocalVariable)declaredElements[i]).getType();
                    if (variableType.equals(baseType)) continue;
                    hasMultipleTypes = true;
                }
                highlightType = hasMultipleTypes ? ProblemHighlightType.WARNING : ProblemHighlightType.INFORMATION;
            } else {
                highlightType = ProblemHighlightType.WARNING;
            }
            if (highlightType == ProblemHighlightType.INFORMATION || InspectionProjectProfileManager.isInformationLevel((String)MultipleVariablesInDeclarationInspection.this.getShortName(), (PsiElement)statement)) {
                if (this.isOnTheFly()) {
                    this.registerError((PsiElement)statement, highlightType, new Object[0]);
                }
            } else {
                PsiIdentifier nameIdentifier = ((PsiVariable)declaredElements[0]).getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                this.registerError((PsiElement)nameIdentifier, highlightType, new Object[0]);
            }
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            if (field instanceof PsiEnumConstant) {
                return;
            }
            if (DeclarationSearchUtils.findFirstFieldInDeclaration(field) != field) {
                if (!this.isVisibleHighlight((PsiElement)field)) {
                    this.registerError((PsiElement)field, new Object[0]);
                }
                return;
            }
            if (DeclarationSearchUtils.findNextFieldInDeclaration(field) == null) {
                return;
            }
            boolean isVisibleHighlight = this.isVisibleHighlight((PsiElement)field);
            if (MultipleVariablesInDeclarationInspection.this.onlyWarnArrayDimensions) {
                if (isVisibleHighlight) {
                    PsiField nextField = DeclarationSearchUtils.findNextFieldInDeclaration(field);
                    PsiType baseType = field.getType();
                    while (nextField != null) {
                        if (!baseType.equals(nextField.getType())) {
                            this.registerVariableError((PsiVariable)field, new Object[0]);
                            return;
                        }
                        nextField = DeclarationSearchUtils.findNextFieldInDeclaration(nextField);
                    }
                }
                if (!this.isOnTheFly()) {
                    return;
                }
                this.registerError((PsiElement)field, ProblemHighlightType.INFORMATION, new Object[0]);
            } else if (!isVisibleHighlight) {
                this.registerError((PsiElement)field, new Object[0]);
            } else {
                this.registerVariableError((PsiVariable)field, new Object[0]);
            }
        }
    }
}

