/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantOnWrongSideOfComparisonInspection
extends BaseInspection {
    public boolean myConstantShouldGoLeft = true;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return this.myConstantShouldGoLeft ? InspectionGadgetsBundle.message("constant.on.rhs.of.comparison.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("constant.on.lhs.of.comparison.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        String left = "left";
        String right = "right";
        ComboBox comboBox = new ComboBox((Object[])new String[]{"left", "right"});
        comboBox.setSelectedIndex(this.myConstantShouldGoLeft ? 0 : 1);
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.myConstantShouldGoLeft = e.getItem() == "left";
            }
        });
        JLabel label = new JLabel(JavaAnalysisBundle.message((String)"inspection.constant.on.wrong.side.of.a.comparison.side.option", (Object[])new Object[0]));
        JPanel panel2 = new JPanel(new FlowLayout(3));
        panel2.add(label);
        panel2.add((Component)comboBox);
        return panel2;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SwapComparisonFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantOnSideOfComparisonVisitor();
    }

    private class ConstantOnSideOfComparisonVisitor
    extends BaseInspectionVisitor {
        private ConstantOnSideOfComparisonVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            if (!ComparisonUtils.isComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            if (!this.isConstantExpression(ConstantOnWrongSideOfComparisonInspection.this.myConstantShouldGoLeft ? lhs : rhs) && this.isConstantExpression(ConstantOnWrongSideOfComparisonInspection.this.myConstantShouldGoLeft ? rhs : lhs) && !ErrorUtil.containsDeepError((PsiElement)expression2)) {
                this.registerError((PsiElement)(ConstantOnWrongSideOfComparisonInspection.this.myConstantShouldGoLeft ? rhs : lhs), new Object[0]);
            }
        }

        private boolean isConstantExpression(PsiExpression expression2) {
            return ExpressionUtils.isNullLiteral(expression2) || PsiUtil.isConstantExpression((PsiExpression)expression2);
        }
    }

    private static class SwapComparisonFix
    extends InspectionGadgetsFix {
        private SwapComparisonFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("flip.comparison.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression expression2 = (PsiBinaryExpression)element;
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            String flippedComparison = ComparisonUtils.getFlippedComparison(expression2.getOperationTokenType());
            if (flippedComparison == null) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            CommentTracker commentTracker = new CommentTracker();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, commentTracker.text((PsiElement)rhs) + flippedComparison + commentTracker.text((PsiElement)lhs), commentTracker);
        }
    }
}

