/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class NonSerializableWithSerialVersionUIDFieldInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonSerializableClassWithSerialVersionUID";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass.isAnnotationType()) {
            return InspectionGadgetsBundle.message("non.serializable.@interface.with.serialversionuid.problem.descriptor", new Object[0]);
        }
        if (aClass.isInterface()) {
            return InspectionGadgetsBundle.message("non.serializable.interface.with.serialversionuid.problem.descriptor", new Object[0]);
        }
        if (aClass instanceof PsiAnonymousClass) {
            return InspectionGadgetsBundle.message("non.serializable.anonymous.with.serialversionuid.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("non.serializable.class.with.serialversionuid.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray;
        PsiClass aClass = (PsiClass)infos[0];
        PsiField field = aClass.findFieldByName("serialVersionUID", false);
        if (field == null) {
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        boolean onTheFly = (Boolean)infos[1];
        DelegatingFix removeFieldFix = new DelegatingFix((LocalQuickFix)QuickFixFactory.getInstance().createSafeDeleteFix((PsiElement)field));
        if (aClass.isAnnotationType() || aClass.isInterface() || aClass instanceof PsiAnonymousClass) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray2;
            if (onTheFly) {
                InspectionGadgetsFix[] inspectionGadgetsFixArray3 = new InspectionGadgetsFix[1];
                inspectionGadgetsFixArray2 = inspectionGadgetsFixArray3;
                inspectionGadgetsFixArray3[0] = removeFieldFix;
            } else {
                inspectionGadgetsFixArray2 = InspectionGadgetsFix.EMPTY_ARRAY;
            }
            return inspectionGadgetsFixArray2;
        }
        if (onTheFly) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray4 = new InspectionGadgetsFix[2];
            inspectionGadgetsFixArray4[0] = DelegatingFixFactory.createMakeSerializableFix(aClass);
            inspectionGadgetsFixArray = inspectionGadgetsFixArray4;
            inspectionGadgetsFixArray4[1] = removeFieldFix;
        } else {
            InspectionGadgetsFix[] inspectionGadgetsFixArray5 = new InspectionGadgetsFix[1];
            inspectionGadgetsFixArray = inspectionGadgetsFixArray5;
            inspectionGadgetsFixArray5[0] = DelegatingFixFactory.createMakeSerializableFix(aClass);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableWithSerialVersionUIDVisitor();
    }

    private static class NonSerializableWithSerialVersionUIDVisitor
    extends BaseInspectionVisitor {
        private NonSerializableWithSerialVersionUIDVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField field = aClass.findFieldByName("serialVersionUID", false);
            if (field == null) {
                return;
            }
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass, this.isOnTheFly());
        }
    }
}

