/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantClassCallInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final CallMatcher IS_INSTANCE = CallMatcher.exactInstanceCall("java.lang.Class", "isInstance").parameterCount(1);
    private static final CallMatcher CAST = CallMatcher.exactInstanceCall("java.lang.Class", "cast").parameterCount(1);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiExpression qualifier;
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                boolean isInstance = IS_INSTANCE.test(call);
                boolean cast = CAST.test(call);
                if ((isInstance || cast) && (qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression())) instanceof PsiClassObjectAccessExpression) {
                    PsiTypeElement typeElement = ((PsiClassObjectAccessExpression)qualifier).getOperand();
                    PsiType classType = typeElement.getType();
                    PsiExpression argument = call.getArgumentList().getExpressions()[0];
                    PsiType argumentType = argument.getType();
                    if (argumentType == null || !argumentType.isConvertibleFrom(classType)) {
                        return;
                    }
                    ReplaceRedundantClassCallFix fix = isInstance ? new ReplaceWithInstanceOfFix(typeElement) : new ReplaceWithCastFix(typeElement);
                    holder.registerProblem(nameElement, InspectionGadgetsBundle.message("redundant.call.problem.descriptor", new Object[0]), new LocalQuickFix[]{fix});
                }
            }
        };
    }

    private static class ReplaceWithCastFix
    extends ReplaceRedundantClassCallFix {
        ReplaceWithCastFix(@NotNull PsiTypeElement typeElement) {
            super("(" + typeElement.getType().getPresentableText() + ")");
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("replace.with.cast.fix.family.name", new Object[0]);
        }

        @Override
        @NotNull
        String createReplacement(String argText, String classText) {
            return "(" + classText + ")" + argText;
        }
    }

    private static class ReplaceWithInstanceOfFix
    extends ReplaceRedundantClassCallFix {
        ReplaceWithInstanceOfFix(@NotNull PsiTypeElement typeElement) {
            super("instanceof " + typeElement.getType().getPresentableText());
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"instanceof"});
        }

        @Override
        @NotNull
        String createReplacement(String argText, String classText) {
            return argText + " instanceof " + classText;
        }
    }

    private static abstract class ReplaceRedundantClassCallFix
    implements LocalQuickFix {
        final String myReplacement;

        ReplaceRedundantClassCallFix(String replacement) {
            this.myReplacement = replacement;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacement});
        }

        public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
            if (arg == null) {
                return;
            }
            PsiClassObjectAccessExpression qualifier = (PsiClassObjectAccessExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression()), PsiClassObjectAccessExpression.class);
            if (qualifier == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)call, this.createReplacement(ct.text((PsiElement)arg), ct.text((PsiElement)qualifier.getOperand())));
        }

        @NotNull
        abstract String createReplacement(String var1, String var2);
    }
}

