/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.inheritance.ImplicitSubclassProvider;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class UtilityClassUtil {
    private UtilityClassUtil() {
    }

    public static boolean hasPrivateEmptyOrNoConstructor(@NotNull PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        if (constructors.length != 1) {
            return false;
        }
        PsiMethod constructor = constructors[0];
        return constructor.hasModifierProperty("private") && ControlFlowUtils.isEmptyCodeBlock(constructor.getBody());
    }

    public static boolean isUtilityClass(@NotNull PsiClass aClass) {
        return UtilityClassUtil.isUtilityClass(aClass, true);
    }

    public static boolean isUtilityClass(@NotNull PsiClass aClass, boolean fullCheck) {
        if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiReferenceList extendsList = aClass.getExtendsList();
        if (fullCheck && extendsList != null && extendsList.getReferencedTypes().length > 0) {
            return false;
        }
        PsiReferenceList implementsList = aClass.getImplementsList();
        if (implementsList != null && implementsList.getReferencedTypes().length > 0) {
            return false;
        }
        int staticMethodCount = UtilityClassUtil.countStaticMethods(aClass.getMethods());
        if (staticMethodCount < 0) {
            return false;
        }
        int staticFieldCount = UtilityClassUtil.countStaticFields(aClass.getFields());
        if (staticFieldCount < 0) {
            return false;
        }
        if (fullCheck) {
            for (ImplicitSubclassProvider subclassProvider : (ImplicitSubclassProvider[])ImplicitSubclassProvider.EP_NAME.getExtensions()) {
                if (!subclassProvider.isApplicableTo(aClass) || subclassProvider.getSubclassingInfo(aClass) == null) continue;
                return false;
            }
        }
        return !fullCheck || staticMethodCount != 0 || staticFieldCount != 0;
    }

    private static int countStaticFields(PsiField[] fields) {
        int count = 0;
        for (PsiField field : fields) {
            if (!field.hasModifierProperty("static")) {
                return -1;
            }
            if (field.hasModifierProperty("private")) continue;
            ++count;
        }
        return count;
    }

    private static int countStaticMethods(PsiMethod[] methods) {
        int staticCount = 0;
        for (PsiMethod method : methods) {
            if (method.isConstructor()) continue;
            if (!method.hasModifierProperty("static")) {
                return -1;
            }
            if (method.hasModifierProperty("private")) continue;
            ++staticCount;
        }
        return staticCount;
    }
}

