/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import org.jetbrains.annotations.NotNull;

class RecursionVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean recursive;
    private final PsiMethod method;
    private final String methodName;

    RecursionVisitor(@NotNull PsiMethod method) {
        this.method = method;
        this.methodName = method.getName();
    }

    public void visitElement(@NotNull PsiElement element) {
        if (!this.recursive) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        if (this.recursive) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String calledMethodName = methodExpression.getReferenceName();
        if (!this.methodName.equals(calledMethodName)) {
            return;
        }
        PsiMethod calledMethod = call.resolveMethod();
        if (!this.method.equals(calledMethod)) {
            return;
        }
        if (this.method.hasModifierProperty("static") || this.method.hasModifierProperty("private")) {
            this.recursive = true;
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiThisExpression) {
            this.recursive = true;
        }
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

