/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodUtils {
    private MethodUtils() {
    }

    public static boolean isCopyConstructor(@Nullable PsiMethod constructor) {
        if (constructor == null || !constructor.isConstructor()) {
            return false;
        }
        PsiParameter[] parameters2 = constructor.getParameterList().getParameters();
        return parameters2.length == 1 && constructor.getContainingClass() == PsiUtil.resolveClassInClassTypeOnly((PsiType)parameters2[0].getType());
    }

    @Contract(value="null -> false")
    public static boolean isComparatorCompare(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, "java.util.Comparator", (PsiType)PsiType.INT, "compare", null, null);
    }

    @Contract(value="null -> false")
    public static boolean isCompareTo(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, null, (PsiType)PsiType.INT, "compareTo", new PsiType[]{PsiType.NULL}) && InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)"java.lang.Comparable");
    }

    @Contract(value="null -> false")
    public static boolean isCompareToIgnoreCase(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method);
        return MethodUtils.methodMatches(method, "java.lang.String", (PsiType)PsiType.INT, "compareToIgnoreCase", new PsiType[]{stringType});
    }

    @Contract(value="null -> false")
    public static boolean isHashCode(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, null, (PsiType)PsiType.INT, "hashCode", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isFinalize(@Nullable PsiMethod method) {
        return method != null && MethodUtils.methodMatches(method, null, (PsiType)PsiType.VOID, "finalize", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isToString(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method);
        return MethodUtils.methodMatches(method, null, (PsiType)stringType, "toString", new PsiType[0]);
    }

    @Contract(value="null -> false")
    public static boolean isEquals(@Nullable PsiMethod method) {
        if (method == null || !"equals".equals(method.getName())) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        return parameterList.getParametersCount() == 1 && PsiType.BOOLEAN.equals((Object)method.getReturnType()) && TypeUtils.isJavaLangObject(Objects.requireNonNull(parameterList.getParameter(0)).getType());
    }

    @Contract(value="null -> false")
    public static boolean isEqualsIgnoreCase(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClassType stringType = TypeUtils.getStringType((PsiElement)method);
        return MethodUtils.methodMatches(method, "java.lang.String", (PsiType)PsiType.BOOLEAN, "equalsIgnoreCase", new PsiType[]{stringType});
    }

    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        String name2;
        Matcher matcher;
        if (methodNamePattern != null && !(matcher = methodNamePattern.matcher(name2 = method.getName())).matches()) {
            return false;
        }
        return MethodUtils.methodMatches(method, containingClassName, returnType, parameterTypes);
    }

    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        String name2 = method.getName();
        if (methodName != null && !methodName.equals(name2)) {
            return false;
        }
        return MethodUtils.methodMatches(method, containingClassName, returnType, parameterTypes);
    }

    private static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, PsiType ... parameterTypes) {
        if (parameterTypes != null) {
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != parameterTypes.length) {
                return false;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            for (int i = 0; i < parameters2.length; ++i) {
                ProgressManager.checkCanceled();
                PsiParameter parameter2 = parameters2[i];
                PsiType type2 = parameter2.getType();
                PsiType parameterType = parameterTypes[i];
                if (PsiType.NULL.equals((Object)parameterType) || parameterType == null || EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(type2, parameterType)) continue;
                return false;
            }
        }
        if (returnType != null) {
            PsiType methodReturnType = method.getReturnType();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(returnType, methodReturnType)) {
                return false;
            }
        }
        if (containingClassName != null) {
            PsiClass containingClass = method.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)containingClassName);
        }
        return true;
    }

    public static boolean simpleMethodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @NonNls @Nullable String returnTypeString, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        Project project = method.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        try {
            if (parameterTypeStrings != null) {
                PsiType[] parameterTypes = PsiType.createArray((int)parameterTypeStrings.length);
                for (int i = 0; i < parameterTypeStrings.length; ++i) {
                    ProgressManager.checkCanceled();
                    String parameterTypeString = parameterTypeStrings[i];
                    parameterTypes[i] = factory.createTypeFromText(parameterTypeString, (PsiElement)method);
                }
                if (returnTypeString != null) {
                    PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method);
                    return MethodUtils.methodMatches(method, containingClassName, returnType, methodName, parameterTypes);
                }
                return MethodUtils.methodMatches(method, containingClassName, null, methodName, parameterTypes);
            }
            if (returnTypeString != null) {
                PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method);
                return MethodUtils.methodMatches(method, containingClassName, returnType, methodName, new PsiType[0]);
            }
            return MethodUtils.methodMatches(method, containingClassName, null, methodName, new PsiType[0]);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasSuper(@NotNull PsiMethod method) {
        return MethodUtils.getSuper(method) != null;
    }

    @Nullable
    public static PsiMethod getSuper(@NotNull PsiMethod method) {
        MethodSignatureBackedByPsiMethod signature = MethodUtils.getSuperMethodSignature(method);
        if (signature == null) {
            return null;
        }
        return signature.getMethod();
    }

    @Nullable
    public static MethodSignatureBackedByPsiMethod getSuperMethodSignature(@NotNull PsiMethod method) {
        if (method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
            return null;
        }
        return (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
    }

    public static boolean isOverridden(@NotNull PsiMethod method) {
        return OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
    }

    public static boolean isOverriddenInHierarchy(@NotNull PsiMethod method, @NotNull PsiClass baseClass) {
        if (!PsiUtil.canBeOverridden((PsiMethod)method) || baseClass instanceof PsiAnonymousClass || baseClass.hasModifierProperty("final")) {
            return false;
        }
        Query search = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)baseClass.getUseScope(), (boolean)true, (boolean)true, (boolean)true);
        for (PsiClass inheritor : search) {
            PsiMethod overridingMethod = inheritor.findMethodBySignature(method, false);
            if (overridingMethod == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(PsiMethod method) {
        return ControlFlowUtils.isEmptyCodeBlock(method.getBody());
    }

    public static boolean isTrivial(PsiMethod method, boolean throwIsTrivial) {
        if (method.hasModifierProperty("native")) {
            return false;
        }
        return MethodUtils.isTrivial(method.getBody(), throwIsTrivial);
    }

    public static boolean isTrivial(PsiClassInitializer initializer) {
        return MethodUtils.isTrivial(initializer.getBody(), false);
    }

    private static boolean isTrivial(PsiCodeBlock codeBlock, boolean throwIsTrivial) {
        if (codeBlock == null) {
            return true;
        }
        PsiStatement[] statements = codeBlock.getStatements();
        if (statements.length == 0) {
            return true;
        }
        for (PsiStatement statement : statements) {
            ProgressManager.checkCanceled();
            if (statement instanceof PsiEmptyStatement) continue;
            if (statement instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
                PsiExpression returnValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)returnStatement.getReturnValue());
                if (returnValue != null && !(returnValue instanceof PsiLiteralExpression)) continue;
                return true;
            }
            if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiExpression condition2 = ifStatement.getCondition();
                Object result = ExpressionUtils.computeConstantExpression(condition2);
                if (result != null && result.equals(Boolean.FALSE)) continue;
                return false;
            }
            if (statement instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
                if (JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)expressionStatement.getExpression())) continue;
                return false;
            }
            return throwIsTrivial && statement instanceof PsiThrowStatement;
        }
        return true;
    }

    public static boolean hasInThrows(@NotNull PsiMethod method, String ... exceptions) {
        PsiJavaCodeReferenceElement[] references;
        if (exceptions.length == 0) {
            throw new IllegalArgumentException("no exceptions specified");
        }
        PsiReferenceList throwsList = method.getThrowsList();
        for (PsiJavaCodeReferenceElement reference : references = throwsList.getReferenceElements()) {
            ProgressManager.checkCanceled();
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)target;
            String qualifiedName = aClass.getQualifiedName();
            for (String exception : exceptions) {
                if (!exception.equals(qualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isChainable(PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)method.getContainingClass(), (PsiClass)PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType()), (boolean)true)) {
            return false;
        }
        PsiElement navigationElement = method.getNavigationElement();
        if (!(navigationElement instanceof PsiMethod)) {
            return false;
        }
        method = (PsiMethod)navigationElement;
        PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(method.getBody());
        if (!(lastStatement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)lastStatement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        return returnValue instanceof PsiThisExpression;
    }

    public static boolean haveEquivalentModifierLists(PsiMethod method, PsiMethod superMethod) {
        PsiModifierList list1 = method.getModifierList();
        PsiModifierList list2 = superMethod.getModifierList();
        if (list1.hasModifierProperty("strictfp") != list2.hasModifierProperty("strictfp") || list1.hasModifierProperty("synchronized") != list2.hasModifierProperty("synchronized") || list1.hasModifierProperty("public") != list2.hasModifierProperty("public") || list1.hasModifierProperty("protected") != list2.hasModifierProperty("protected") || list1.hasModifierProperty("final") != list2.hasModifierProperty("final") || list1.hasModifierProperty("abstract") != list2.hasModifierProperty("abstract")) {
            return false;
        }
        return AnnotationUtil.equal((PsiAnnotation[])list1.getAnnotations(), (PsiAnnotation[])list2.getAnnotations());
    }

    @NotNull
    public static PsiMethod findSpecificMethod(@NotNull PsiMethod method, @Nullable PsiType specificType) {
        PsiClass qualifierClass = method.getContainingClass();
        if (qualifierClass == null) {
            return method;
        }
        if (specificType == null || specificType instanceof PsiArrayType) {
            return method;
        }
        StreamEx types = specificType instanceof PsiIntersectionType ? StreamEx.of((Object[])((PsiIntersectionType)specificType).getConjuncts()) : StreamEx.of((Object)specificType);
        List methods = ((StreamEx)((StreamEx)((StreamEx)types.map(PsiUtil::resolveClassInClassTypeOnly).nonNull().without((Object)qualifierClass).distinct()).filter(specificClass -> InheritanceUtil.isInheritorOrSelf((PsiClass)specificClass, (PsiClass)qualifierClass, (boolean)true))).map(specificClass -> MethodSignatureUtil.findMethodBySuperMethod((PsiClass)specificClass, (PsiMethod)method, (boolean)true)).nonNull().distinct()).toList();
        if (methods.isEmpty()) {
            return method;
        }
        PsiMethod best = (PsiMethod)methods.get(0);
        for (PsiMethod realMethod : methods) {
            if (best.equals(realMethod)) continue;
            if (MethodSignatureUtil.isSuperMethod((PsiMethod)best, (PsiMethod)realMethod)) {
                best = realMethod;
                continue;
            }
            if (MethodSignatureUtil.isSuperMethod((PsiMethod)realMethod, (PsiMethod)best)) continue;
            return method;
        }
        return best;
    }

    public static boolean isFactoryMethod(PsiMethod method) {
        if (!method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType());
        return aClass != null && aClass.equals(method.getContainingClass());
    }

    public static boolean isConvenienceOverload(PsiMethod method) {
        PsiType returnType = method.getReturnType();
        PsiCodeBlock body2 = method.getBody();
        PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(body2);
        if (statement == null) {
            return false;
        }
        if (PsiType.VOID.equals((Object)returnType)) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression2 = expressionStatement.getExpression();
            return MethodUtils.isCallToOverloadedMethod(expression2, method);
        }
        if (!(statement instanceof PsiReturnStatement)) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression returnValue = returnStatement.getReturnValue();
        return MethodUtils.isCallToOverloadedMethod(returnValue, method);
    }

    private static boolean isCallToOverloadedMethod(PsiExpression expression2, PsiMethod method) {
        if (!((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        String name2 = methodCallExpression.getMethodExpression().getReferenceName();
        if (!method.getName().equals(name2)) {
            return false;
        }
        PsiMethod calledMethod = methodCallExpression.resolveMethod();
        if (calledMethod == null || calledMethod.getParameterList().getParametersCount() < method.getParameterList().getParametersCount()) {
            return false;
        }
        return calledMethod.getContainingClass() == method.getContainingClass();
    }
}

