/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommentTracker {
    private final Set<PsiElement> ignoredParents = new HashSet<PsiElement>();
    private List<PsiComment> comments = new ArrayList<PsiComment>();
    private PsiElement lastTextWithCommentsElement = null;

    @NotNull
    public String text(@NotNull PsiElement element) {
        this.checkState();
        this.addIgnored(element);
        return element.getText();
    }

    @NotNull
    public String text(@NotNull PsiExpression element, int precedence) {
        this.checkState();
        this.addIgnored((PsiElement)element);
        return ParenthesesUtils.getText(element, precedence + 1);
    }

    @NotNull
    public String lambdaText(@NotNull PsiVariable variable, @NotNull PsiExpression expression2) {
        return variable.getName() + " -> " + this.text((PsiElement)expression2);
    }

    @Contract(value="_ -> param1")
    public <T extends PsiElement> T markUnchanged(@Nullable T element) {
        this.checkState();
        if (element != null) {
            this.addIgnored(element);
        }
        return element;
    }

    public String rangeText(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement) {
        PsiElement e;
        this.checkState();
        StringBuilder result = new StringBuilder();
        for (e = firstElement; e != null && e != lastElement; e = e.getNextSibling()) {
            this.addIgnored(e);
            result.append(e.getText());
        }
        if (e == null) {
            throw new IllegalArgumentException("Elements must be siblings: " + firstElement + " and " + lastElement);
        }
        this.addIgnored(lastElement);
        result.append(lastElement.getText());
        return result.toString();
    }

    public void markRangeUnchanged(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement) {
        PsiElement e;
        this.checkState();
        for (e = firstElement; e != null && e != lastElement; e = e.getNextSibling()) {
            this.addIgnored(e);
        }
        if (e == null) {
            throw new IllegalArgumentException("Elements must be siblings: " + firstElement + " and " + lastElement);
        }
        this.addIgnored(lastElement);
    }

    public String commentsBefore(@NotNull PsiElement element) {
        List<PsiElement> comments = this.grabCommentsBefore(element);
        if (comments.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (PsiElement comment : comments) {
            PsiElement prev = comment.getPrevSibling();
            if (sb.length() == 0 && prev instanceof PsiWhiteSpace) {
                sb.append(prev.getText());
            }
            sb.append(comment.getText());
            PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)comment);
            if (!(next instanceof PsiWhiteSpace)) continue;
            sb.append(next.getText());
        }
        comments.forEach(PsiElement::delete);
        return sb.toString();
    }

    private List<PsiElement> grabCommentsBefore(@NotNull PsiElement element) {
        if (this.lastTextWithCommentsElement == null) {
            this.lastTextWithCommentsElement = element;
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        int start = this.lastTextWithCommentsElement.getTextRange().getEndOffset();
        int end = element.getTextRange().getStartOffset();
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)this.lastTextWithCommentsElement, (PsiElement)element);
        if (parent != null && start < end) {
            PsiTreeUtil.processElements((PsiElement)parent, arg_0 -> this.lambda$grabCommentsBefore$0(start, end, (List)result, arg_0));
        }
        this.lastTextWithCommentsElement = element;
        return result;
    }

    public String textWithComments(@NotNull PsiElement element) {
        return this.commentsBefore(element) + element.getText();
    }

    public String textWithComments(@NotNull PsiExpression expression2, int precedence) {
        return this.commentsBefore((PsiElement)expression2) + ParenthesesUtils.getText(expression2, precedence + 1);
    }

    public void delete(@NotNull PsiElement element) {
        this.grabCommentsOnDelete(element);
        element.delete();
    }

    public void delete(PsiElement ... elements) {
        for (PsiElement element : elements) {
            this.delete(element);
        }
    }

    public void deleteAndRestoreComments(@NotNull PsiElement element) {
        PsiElement anchor;
        this.grabCommentsOnDelete(element);
        for (anchor = element; anchor.getParent() != null && !(anchor.getParent() instanceof PsiFile) && anchor.getParent().getFirstChild() == anchor; anchor = anchor.getParent()) {
        }
        this.insertCommentsBefore(anchor);
        element.delete();
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        this.markUnchanged(replacement);
        this.grabComments(element);
        return element.replace(replacement);
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull String text2) {
        PsiElement replacement = CommentTracker.createElement(element, text2);
        return this.replace(element, replacement);
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        List<PsiElement> suffix = this.grabSuffixComments(element);
        PsiElement result = this.replace(element, replacement);
        PsiElement anchor = PsiTreeUtil.getNonStrictParentOfType((PsiElement)result, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class, PsiVariable.class, PsiNameValuePair.class});
        if (anchor instanceof PsiLambdaExpression && anchor != result) {
            anchor = ((PsiLambdaExpression)anchor).getBody();
        }
        if (anchor instanceof PsiVariable && anchor.getParent() instanceof PsiDeclarationStatement) {
            anchor = anchor.getParent();
        }
        if (anchor instanceof PsiStatement && (anchor.getParent() instanceof PsiIfStatement || anchor.getParent() instanceof PsiLoopStatement)) {
            anchor = anchor.getParent();
        }
        if (anchor == null) {
            anchor = result;
        }
        CommentTracker.restoreSuffixComments(result, suffix);
        this.insertCommentsBefore(anchor);
        return result;
    }

    @NotNull
    public PsiElement replaceExpressionAndRestoreComments(@NotNull PsiExpression expression2, @NotNull String replacementText) {
        return this.replaceExpressionAndRestoreComments(expression2, replacementText, Collections.emptyList());
    }

    @NotNull
    public PsiElement replaceExpressionAndRestoreComments(@NotNull PsiExpression expression2, @NotNull String replacementText, List<? extends PsiElement> toDelete) {
        SmartList trailingComments = new SmartList();
        List<PsiElement> comments = this.grabCommentsBefore(PsiTreeUtil.lastChild((PsiElement)expression2));
        if (!comments.isEmpty()) {
            PsiParserFacade parser = PsiParserFacade.SERVICE.getInstance((Project)expression2.getProject());
            for (PsiElement comment : comments) {
                PsiElement prev = comment.getPrevSibling();
                if (prev instanceof PsiWhiteSpace) {
                    String text2 = prev.getText();
                    if (!text2.contains("\n")) {
                        trailingComments.add(parser.createWhiteSpaceFromText(" "));
                    } else if (text2.endsWith("\n")) {
                        trailingComments.add(parser.createWhiteSpaceFromText("\n"));
                    } else {
                        trailingComments.add(parser.createWhiteSpaceFromText("\n "));
                    }
                }
                this.ignoredParents.add(comment);
                trailingComments.add(comment.copy());
            }
            Collections.reverse(trailingComments);
        }
        PsiElement replacement = this.replace((PsiElement)expression2, replacementText);
        for (PsiElement element : trailingComments) {
            replacement.getParent().addAfter(element, replacement);
        }
        toDelete.forEach(this::delete);
        this.insertCommentsBefore(replacement);
        return replacement;
    }

    @NotNull
    private List<PsiElement> grabSuffixComments(@NotNull PsiElement element) {
        if (!(element instanceof PsiStatement)) {
            return Collections.emptyList();
        }
        ArrayList<PsiElement> suffix = new ArrayList<PsiElement>();
        PsiElement lastChild = element.getLastChild();
        boolean hasComment = false;
        while (lastChild instanceof PsiComment || lastChild instanceof PsiWhiteSpace) {
            hasComment |= lastChild instanceof PsiComment;
            if (!(lastChild instanceof PsiComment) || !this.shouldIgnore((PsiComment)lastChild)) {
                suffix.add(this.markUnchanged(lastChild).copy());
            }
            lastChild = lastChild.getPrevSibling();
        }
        return hasComment ? suffix : Collections.emptyList();
    }

    private static void restoreSuffixComments(PsiElement target, List<? extends PsiElement> suffix) {
        if (!suffix.isEmpty()) {
            PsiElement lastChild = target.getLastChild();
            if (lastChild instanceof PsiComment && JavaTokenType.END_OF_LINE_COMMENT.equals(((PsiComment)lastChild).getTokenType())) {
                PsiElement nextSibling = target.getNextSibling();
                if (nextSibling instanceof PsiWhiteSpace) {
                    target.add(nextSibling);
                } else {
                    target.add(PsiParserFacade.SERVICE.getInstance((Project)target.getProject()).createWhiteSpaceFromText("\n"));
                }
            }
            StreamEx.ofReversed(suffix).forEach(arg_0 -> ((PsiElement)target).add(arg_0));
        }
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull String text2) {
        PsiElement replacement = CommentTracker.createElement(element, text2);
        return this.replaceAndRestoreComments(element, replacement);
    }

    @NotNull
    private static PsiElement createElement(@NotNull PsiElement element, @NotNull String text2) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        if (element instanceof PsiExpression) {
            return factory.createExpressionFromText(text2, element);
        }
        if (element instanceof PsiStatement) {
            return factory.createStatementFromText(text2, element);
        }
        if (element instanceof PsiTypeElement) {
            return factory.createTypeElementFromText(text2, element);
        }
        if (element instanceof PsiIdentifier) {
            return factory.createIdentifier(text2);
        }
        if (element instanceof PsiComment) {
            return factory.createCommentFromText(text2, element);
        }
        throw new IllegalArgumentException("Unsupported element type: " + element);
    }

    public void insertCommentsBefore(@NotNull PsiElement anchor) {
        this.checkState();
        if (!this.comments.isEmpty()) {
            PsiElement parent = anchor.getParent();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
            for (PsiComment comment : this.comments) {
                PsiElement added;
                PsiElement prevSibling;
                if (this.shouldIgnore(comment) || !((prevSibling = (added = parent.addBefore((PsiElement)factory.createCommentFromText(comment.getText(), anchor), anchor)).getPrevSibling()) instanceof PsiWhiteSpace)) continue;
                PsiElement prev = anchor.getPrevSibling();
                ASTNode whiteSpaceBefore = CommentTracker.normalizeWhiteSpace((PsiWhiteSpace)prevSibling, prev);
                parent.getNode().addChild(whiteSpaceBefore, anchor.getNode());
                if (!(prev instanceof PsiWhiteSpace)) continue;
                prev.delete();
            }
        }
        this.comments = null;
    }

    @NotNull
    private static ASTNode normalizeWhiteSpace(PsiWhiteSpace whiteSpace, PsiElement nextElement) {
        int endLPos;
        String text2 = whiteSpace.getText();
        if (text2.lastIndexOf(10, (endLPos = text2.lastIndexOf(10)) - 1) >= 0) {
            return ASTFactory.whitespace((CharSequence)text2.substring(endLPos));
        }
        if (nextElement instanceof PsiWhiteSpace && nextElement.getText().contains("\n") && !text2.contains("\n")) {
            text2 = '\n' + text2;
        }
        return ASTFactory.whitespace((CharSequence)text2);
    }

    private boolean shouldIgnore(PsiComment comment) {
        return this.ignoredParents.stream().anyMatch(p -> PsiTreeUtil.isAncestor((PsiElement)p, (PsiElement)comment, (boolean)false));
    }

    private void grabCommentsOnDelete(PsiElement element) {
        if (element instanceof PsiExpression && element.getParent() instanceof PsiExpressionStatement || element.getParent() instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)element.getParent()).getDeclaredElements().length == 1) {
            element = element.getParent();
        } else if (element.getParent() instanceof PsiJavaCodeReferenceElement) {
            ASTNode dot;
            PsiElement parent = element.getParent();
            if (element instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)parent).getQualifier() == element && (dot = ((CompositeElement)parent).findChildByRole(55)) != null) {
                PsiElement nextSibling = dot.getPsi().getNextSibling();
                if (nextSibling != null && nextSibling.getTextLength() == 0) {
                    nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextSibling);
                }
                while (nextSibling != null) {
                    nextSibling = this.markUnchanged(nextSibling).getNextSibling();
                }
            }
            element = parent;
        }
        this.grabComments(element);
    }

    public void grabComments(PsiElement element) {
        this.checkState();
        for (PsiComment comment : PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{PsiComment.class})) {
            if (this.shouldIgnore(comment)) continue;
            this.comments.add(comment);
        }
    }

    private void checkState() {
        if (this.comments == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been already used");
        }
    }

    private void addIgnored(PsiElement element) {
        if (!(element instanceof LeafPsiElement) || element instanceof PsiComment) {
            this.ignoredParents.add(element);
        }
    }

    public static String textWithSurroundingComments(PsiElement element) {
        Predicate<PsiElement> commentOrWhiteSpace = e -> e instanceof PsiComment || e instanceof PsiWhiteSpace;
        List prev = StreamEx.iterate((Object)element.getPrevSibling(), commentOrWhiteSpace, PsiElement::getPrevSibling).toList();
        List next = StreamEx.iterate((Object)element.getNextSibling(), commentOrWhiteSpace, PsiElement::getNextSibling).toList();
        if (StreamEx.of((Object[])new List[]{prev, next}).flatCollection(Function.identity()).anyMatch(PsiComment.class::isInstance)) {
            return StreamEx.ofReversed((List)prev).append((Object)element).append((Collection)next).map(PsiElement::getText).joining();
        }
        return element.getText();
    }

    @NotNull
    public static String commentsBetween(@NotNull PsiElement start, @NotNull PsiElement end) {
        CommentTracker ct = new CommentTracker();
        ct.lastTextWithCommentsElement = start;
        return ct.commentsBefore(end);
    }

    private /* synthetic */ boolean lambda$grabCommentsBefore$0(int start, int end, List result, PsiElement e) {
        TextRange range;
        if (e instanceof PsiComment && (range = e.getTextRange()).getStartOffset() >= start && range.getEndOffset() <= end && !this.shouldIgnore((PsiComment)e)) {
            result.add(e);
        }
        return true;
    }
}

