/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeBlockSurrounder {
    @NotNull
    final PsiExpression myExpression;

    CodeBlockSurrounder(@NotNull PsiExpression expression2) {
        this.myExpression = expression2;
    }

    @NotNull
    ParentContext getExpectedParentContext() {
        PsiLocalVariable var;
        PsiElement parent = this.myExpression.getParent();
        if (parent instanceof PsiAssignmentExpression && parent.getParent() instanceof PsiExpressionStatement && !(parent.getParent().getParent() instanceof PsiSwitchLabeledRuleStatement) && ((PsiAssignmentExpression)parent).getRExpression() == this.myExpression) {
            return ParentContext.ASSIGNMENT;
        }
        if (parent instanceof PsiLocalVariable && (!(var = (PsiLocalVariable)parent).getTypeElement().isInferredType() || PsiTypesUtil.isDenotableType((PsiType)var.getType(), (PsiElement)parent))) {
            return ParentContext.ASSIGNMENT;
        }
        if (parent instanceof PsiReturnStatement || parent instanceof PsiYieldStatement || parent instanceof PsiThrowStatement) {
            return ParentContext.RETURN;
        }
        if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getElseBranch() == null && ((PsiIfStatement)parent).getThenBranch() != null) {
            return ParentContext.SIMPLE_IF_CONDITION;
        }
        return ParentContext.UNKNOWN;
    }

    @NotNull
    public SurroundResult surround() {
        Object marker = new Object();
        PsiTreeUtil.mark((PsiElement)this.myExpression, (Object)marker);
        Project project = this.myExpression.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        boolean physical = this.myExpression.isPhysical();
        PsiStatement replacement = this.replace(project, factory);
        assert (replacement.isPhysical() == physical);
        PsiExpression newExpression = Objects.requireNonNull((PsiExpression)PsiTreeUtil.releaseMark((PsiElement)replacement, (Object)marker));
        return new SurroundResult(newExpression, replacement);
    }

    @NotNull
    PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
        throw new UnsupportedOperationException();
    }

    public static boolean canSurround(@NotNull PsiExpression expression2) {
        return CodeBlockSurrounder.forExpression(expression2) != null;
    }

    @Nullable
    public static CodeBlockSurrounder forExpression(@NotNull PsiExpression expression2) {
        PsiTypeElement typeElement;
        PsiDeclarationStatement decl;
        PsiElement grandParent;
        PsiExpression cur = expression2;
        PsiElement parent = cur.getParent();
        while (parent instanceof PsiExpression || parent instanceof PsiExpressionList) {
            if (parent instanceof PsiLambdaExpression) {
                return new LambdaCodeBlockSurrounder(expression2, (PsiLambdaExpression)parent);
            }
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                IElementType type2 = polyadicExpression.getOperationTokenType();
                if (type2.equals(JavaTokenType.ANDAND) && polyadicExpression.getOperands()[0] != cur) {
                    PsiElement conditionParent = PsiUtil.skipParenthesizedExprUp((PsiElement)polyadicExpression.getParent());
                    if (conditionParent instanceof PsiWhileStatement) {
                        return new WhileConditionSurrounder(expression2, (PsiWhileStatement)conditionParent);
                    }
                    CodeBlockSurrounder parentSurrounder = CodeBlockSurrounder.forExpressionSkipParentheses((PsiExpression)polyadicExpression);
                    if (parentSurrounder == null) {
                        return null;
                    }
                    ParentContext parentContext = parentSurrounder.getExpectedParentContext();
                    if (parentContext != ParentContext.RETURN && parentContext != ParentContext.SIMPLE_IF_CONDITION) {
                        return null;
                    }
                    return new AndOrToIfSurrounder(expression2, polyadicExpression, parentSurrounder);
                }
                if (type2.equals(JavaTokenType.OROR) && polyadicExpression.getOperands()[0] != cur) {
                    CodeBlockSurrounder parentSurrounder = CodeBlockSurrounder.forExpressionSkipParentheses((PsiExpression)polyadicExpression);
                    if (parentSurrounder == null) {
                        return null;
                    }
                    ParentContext parentContext = parentSurrounder.getExpectedParentContext();
                    if (parentContext != ParentContext.RETURN) {
                        return null;
                    }
                    return new AndOrToIfSurrounder(expression2, polyadicExpression, parentSurrounder);
                }
            }
            if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != cur) {
                CodeBlockSurrounder parentSurrounder = CodeBlockSurrounder.forExpressionSkipParentheses((PsiExpression)((PsiConditionalExpression)parent));
                if (parentSurrounder == null) {
                    return null;
                }
                ParentContext parentContext = parentSurrounder.getExpectedParentContext();
                if (parentContext != ParentContext.ASSIGNMENT && parentContext != ParentContext.RETURN) {
                    return null;
                }
                return new TernaryToIfSurrounder(expression2, (PsiConditionalExpression)parent, parentSurrounder);
            }
            if (JavaPsiConstructorUtil.isConstructorCall((PsiElement)parent)) {
                return null;
            }
            cur = parent;
            parent = cur.getParent();
        }
        if (parent instanceof PsiStatement && (grandParent = parent.getParent()) instanceof PsiForStatement && ((PsiForStatement)grandParent).getUpdate() == parent) {
            return null;
        }
        if (parent instanceof PsiWhileStatement && ((PsiWhileStatement)parent).getCondition() == cur) {
            return new WhileConditionSurrounder(expression2, (PsiWhileStatement)parent);
        }
        if (parent instanceof PsiForeachStatement && ((PsiForeachStatement)parent).getIteratedValue() == cur || parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getCondition() == cur || parent instanceof PsiReturnStatement || parent instanceof PsiExpressionStatement || parent instanceof PsiYieldStatement || parent instanceof PsiThrowStatement) {
            return CodeBlockSurrounder.forStatement((PsiStatement)parent, expression2);
        }
        if (parent instanceof PsiLocalVariable && (decl = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)parent.getParent(), PsiDeclarationStatement.class)) != null && ArrayUtil.getFirstElement((Object[])decl.getDeclaredElements()) == parent && (!(typeElement = ((PsiLocalVariable)parent).getTypeElement()).isInferredType() || PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)((PsiLocalVariable)parent.copy()).getTypeElement()) != null)) {
            PsiElement declParent = decl.getParent();
            if (declParent instanceof PsiForStatement && ((PsiForStatement)declParent).getInitialization() == decl) {
                if (CodeBlockSurrounder.hasNameCollision((PsiElement)decl, declParent.getParent())) {
                    return new SimpleSurrounder(expression2, (PsiStatement)((PsiForStatement)declParent));
                }
                return CodeBlockSurrounder.forStatement((PsiStatement)declParent, expression2);
            }
            return CodeBlockSurrounder.forStatement((PsiStatement)decl, expression2);
        }
        if (parent instanceof PsiResourceVariable) {
            PsiResourceList list = (PsiResourceList)ObjectUtils.tryCast((Object)parent.getParent(), PsiResourceList.class);
            if (list != null && list.getParent() instanceof PsiTryStatement) {
                return new SplitTrySurrounder(expression2, (PsiResourceVariable)parent, (PsiTryStatement)list.getParent());
            }
            return null;
        }
        if (parent instanceof PsiField) {
            return new ExtractFieldInitializerSurrounder(expression2, (PsiField)parent);
        }
        return null;
    }

    @Nullable
    private static CodeBlockSurrounder forExpressionSkipParentheses(PsiExpression expression2) {
        while (expression2.getParent() instanceof PsiParenthesizedExpression) {
            expression2 = (PsiExpression)expression2.getParent();
        }
        return CodeBlockSurrounder.forExpression(expression2);
    }

    private static boolean hasNameCollision(PsiElement declaration2, PsiElement context) {
        if (declaration2 instanceof PsiDeclarationStatement) {
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
            return StreamEx.of((Object[])((PsiDeclarationStatement)declaration2).getDeclaredElements()).select(PsiLocalVariable.class).map(PsiLocalVariable::getName).nonNull().anyMatch(name2 -> helper.resolveAccessibleReferencedVariable(name2, context) != null);
        }
        return false;
    }

    private static CodeBlockSurrounder forStatement(PsiStatement statement, PsiExpression expression2) {
        PsiElement statementParent = statement.getParent();
        if (statementParent instanceof PsiLabeledStatement || statementParent instanceof PsiForStatement) {
            statement = (PsiStatement)statementParent;
            statementParent = statement.getParent();
        }
        if (statementParent instanceof PsiCodeBlock) {
            return new NoOpSurrounder(expression2, statement);
        }
        if (statement instanceof PsiExpressionStatement && statementParent instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)statementParent).getEnclosingSwitchBlock() instanceof PsiSwitchExpression) {
            return new YieldSurrounder(expression2, (PsiExpressionStatement)statement);
        }
        return new SimpleSurrounder(expression2, statement);
    }

    private static class AndOrToIfSurrounder
    extends CodeBlockSurrounder {
        @NotNull
        private final PsiPolyadicExpression myPolyadicExpression;
        @NotNull
        private final CodeBlockSurrounder myUpstream;

        AndOrToIfSurrounder(@NotNull PsiExpression expression2, @NotNull PsiPolyadicExpression polyadicExpression, @NotNull CodeBlockSurrounder upstream) {
            super(expression2);
            this.myPolyadicExpression = polyadicExpression;
            this.myUpstream = upstream;
        }

        @Override
        @NotNull
        public ParentContext getExpectedParentContext() {
            return this.myExpression.getParent() == this.myPolyadicExpression ? this.myUpstream.getExpectedParentContext() : super.getExpectedParentContext();
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            Object[] operands2 = this.myPolyadicExpression.getOperands();
            int index = (int)StreamEx.of((Object[])operands2).indexOf(o -> PsiTreeUtil.isAncestor((PsiElement)o, (PsiElement)this.myExpression, (boolean)false)).orElseThrow(IllegalStateException::new);
            SurroundResult upstreamResult = this.myUpstream.surround();
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)upstreamResult.getExpression()));
            PsiStatement statement = upstreamResult.getAnchor();
            PsiExpression operand2 = polyadicExpression.getOperands()[index];
            PsiExpression lOperands = SplitConditionUtil.getLOperands(polyadicExpression, Objects.requireNonNull(polyadicExpression.getTokenBeforeOperand(operand2)));
            PsiExpression rOperands = AndOrToIfSurrounder.getRightOperands(polyadicExpression, operand2);
            if (statement instanceof PsiIfStatement) {
                return AndOrToIfSurrounder.splitIf((PsiIfStatement)statement, polyadicExpression, lOperands, rOperands, project, factory);
            }
            assert (statement instanceof PsiReturnStatement || statement instanceof PsiYieldStatement);
            return AndOrToIfSurrounder.splitReturn(statement, polyadicExpression, lOperands, rOperands, project, factory);
        }

        @NotNull
        private static PsiStatement splitIf(@NotNull PsiIfStatement outerIf, @NotNull PsiPolyadicExpression andChain, @NotNull PsiExpression lOperands, @NotNull PsiExpression rOperands, @NotNull Project project, @NotNull PsiElementFactory factory) {
            PsiBlockStatement newThenBranch = (PsiBlockStatement)factory.createStatementFromText("{if(true);}", (PsiElement)outerIf);
            PsiStatement thenBranch = Objects.requireNonNull(outerIf.getThenBranch());
            Objects.requireNonNull(((PsiIfStatement)newThenBranch.getCodeBlock().getStatements()[0]).getThenBranch()).replace((PsiElement)thenBranch);
            newThenBranch = (PsiBlockStatement)thenBranch.replace((PsiElement)newThenBranch);
            PsiIfStatement innerIf = (PsiIfStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newThenBranch.getCodeBlock().getStatements()[0]);
            Objects.requireNonNull(innerIf.getCondition()).replace((PsiElement)rOperands);
            andChain.replace((PsiElement)lOperands);
            return innerIf;
        }

        @NotNull
        private static PsiStatement splitReturn(@NotNull PsiStatement returnOrYieldStatement, @NotNull PsiPolyadicExpression condition2, @NotNull PsiExpression lOperands, @NotNull PsiExpression rOperands, @NotNull Project project, @NotNull PsiElementFactory factory) {
            CommentTracker ct = new CommentTracker();
            boolean orChain = condition2.getOperationTokenType().equals(JavaTokenType.OROR);
            String keyword = returnOrYieldStatement.getFirstChild().getText();
            String extractedCondition = orChain ? ct.text((PsiElement)lOperands) : BoolUtils.getNegatedExpressionText(lOperands, ct);
            String ifText = "if(" + extractedCondition + ") " + keyword + " " + orChain + ";";
            PsiStatement ifStatement = factory.createStatementFromText(ifText, (PsiElement)returnOrYieldStatement);
            CodeStyleManager.getInstance((Project)project).reformat(returnOrYieldStatement.getParent().addBefore((PsiElement)ifStatement, (PsiElement)returnOrYieldStatement));
            ct.replaceAndRestoreComments((PsiElement)Objects.requireNonNull(condition2), (PsiElement)rOperands);
            return returnOrYieldStatement;
        }

        private static PsiExpression getRightOperands(PsiPolyadicExpression andChain, PsiExpression operand2) {
            PsiExpression rOperands;
            if (operand2 == ArrayUtil.getLastElement((Object[])andChain.getOperands())) {
                rOperands = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2);
            } else {
                rOperands = SplitConditionUtil.getROperands(andChain, andChain.getTokenBeforeOperand(operand2));
                ((PsiPolyadicExpression)rOperands).getOperands()[0].replace((PsiElement)operand2);
            }
            return rOperands;
        }
    }

    private static class TernaryToIfSurrounder
    extends CodeBlockSurrounder {
        private final PsiConditionalExpression myConditional;
        private final CodeBlockSurrounder myUpstream;

        public TernaryToIfSurrounder(@NotNull PsiExpression expression2, @NotNull PsiConditionalExpression conditional, @NotNull CodeBlockSurrounder upstream) {
            super(expression2);
            this.myConditional = conditional;
            this.myUpstream = upstream;
        }

        @Override
        @NotNull
        public ParentContext getExpectedParentContext() {
            if (this.myConditional.getThenExpression() == this.myExpression || this.myConditional.getElseExpression() == this.myExpression) {
                return this.myUpstream.getExpectedParentContext();
            }
            return super.getExpectedParentContext();
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            boolean then = PsiTreeUtil.isAncestor((PsiElement)this.myConditional.getThenExpression(), (PsiElement)this.myExpression, (boolean)false);
            SurroundResult upstreamResult = this.myUpstream.surround();
            PsiConditionalExpression ternary = Objects.requireNonNull((PsiConditionalExpression)PsiUtil.skipParenthesizedExprDown((PsiExpression)upstreamResult.getExpression()));
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ternary.getParent());
            PsiStatement statement = upstreamResult.getAnchor();
            if (parent instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)parent;
                variable.normalizeDeclaration();
                PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)variable.getParent();
                PsiAssignmentExpression assignment = ExpressionUtils.splitDeclaration(declaration2, project);
                if (assignment != null) {
                    ternary = (PsiConditionalExpression)Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()));
                    statement = (PsiStatement)assignment.getParent();
                }
            }
            CommentTracker ct = new CommentTracker();
            PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText("if(" + ct.text((PsiElement)ternary.getCondition()) + ") {} else {}", (PsiElement)statement);
            Object mark = new Object();
            PsiTreeUtil.mark((PsiElement)ternary, (Object)mark);
            for (PsiElement child : statement.getChildren()) {
                if (!(child instanceof PsiComment)) continue;
                ct.delete(child);
            }
            PsiStatement thenStatement = (PsiStatement)statement.copy();
            PsiConditionalExpression thenTernary = Objects.requireNonNull((PsiConditionalExpression)PsiTreeUtil.releaseMark((PsiElement)thenStatement, (Object)mark));
            PsiExpression thenBranch = ternary.getThenExpression();
            if (thenBranch != null) {
                thenTernary.replace((PsiElement)ct.markUnchanged(thenBranch));
            }
            PsiStatement elseStatement = (PsiStatement)statement.copy();
            PsiConditionalExpression elseTernary = Objects.requireNonNull((PsiConditionalExpression)PsiTreeUtil.releaseMark((PsiElement)elseStatement, (Object)mark));
            PsiExpression elseBranch = ternary.getElseExpression();
            if (elseBranch != null) {
                elseTernary.replace((PsiElement)ct.markUnchanged(elseBranch));
            }
            ifStatement = (PsiIfStatement)ct.replaceAndRestoreComments((PsiElement)statement, (PsiElement)ifStatement);
            thenStatement = (PsiStatement)((PsiBlockStatement)Objects.requireNonNull(ifStatement.getThenBranch())).getCodeBlock().add((PsiElement)thenStatement);
            elseStatement = (PsiStatement)((PsiBlockStatement)Objects.requireNonNull(ifStatement.getElseBranch())).getCodeBlock().add((PsiElement)elseStatement);
            return then ? thenStatement : elseStatement;
        }
    }

    private static class WhileConditionSurrounder
    extends CodeBlockSurrounder {
        private final PsiWhileStatement myStatement;

        WhileConditionSurrounder(@NotNull PsiExpression expression2, @NotNull PsiWhileStatement whileStatement) {
            super(expression2);
            this.myStatement = whileStatement;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            PsiExpression rOperands;
            PsiExpression lOperands;
            PsiBlockStatement blockBody;
            PsiPolyadicExpression polyadic;
            PsiWhileStatement whileStatement = this.myStatement;
            PsiExpression oldCondition = Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)whileStatement.getCondition()));
            PsiStatement body2 = whileStatement.getBody();
            int operandIndex = -1;
            if (oldCondition instanceof PsiPolyadicExpression && (polyadic = (PsiPolyadicExpression)oldCondition).getOperationTokenType().equals(JavaTokenType.ANDAND)) {
                PsiExpression[] operands2 = polyadic.getOperands();
                operandIndex = ContainerUtil.indexOf(Arrays.asList(operands2), o -> PsiTreeUtil.isAncestor((PsiElement)o, (PsiElement)this.myExpression, (boolean)false));
            }
            if (body2 == null) {
                PsiWhileStatement newWhileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", (PsiElement)whileStatement);
                Objects.requireNonNull(newWhileStatement.getCondition()).replace((PsiElement)oldCondition);
                whileStatement = (PsiWhileStatement)whileStatement.replace((PsiElement)newWhileStatement);
                blockBody = (PsiBlockStatement)Objects.requireNonNull(whileStatement.getBody());
                oldCondition = Objects.requireNonNull(whileStatement.getCondition());
            } else if (body2 instanceof PsiBlockStatement) {
                blockBody = (PsiBlockStatement)body2;
            } else {
                PsiBlockStatement newBody = BlockUtils.createBlockStatement(project);
                newBody.getCodeBlock().add((PsiElement)body2);
                blockBody = (PsiBlockStatement)body2.replace((PsiElement)newBody);
            }
            if (operandIndex > 0) {
                PsiPolyadicExpression polyadic2 = (PsiPolyadicExpression)oldCondition;
                PsiExpression operand2 = polyadic2.getOperands()[operandIndex];
                PsiJavaToken token = Objects.requireNonNull(polyadic2.getTokenBeforeOperand(operand2));
                lOperands = SplitConditionUtil.getLOperands(polyadic2, token);
                rOperands = AndOrToIfSurrounder.getRightOperands(polyadic2, operand2);
            } else {
                lOperands = factory.createExpressionFromText("true", (PsiElement)whileStatement);
                rOperands = oldCondition;
            }
            PsiCodeBlock codeBlock = blockBody.getCodeBlock();
            PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText("if(!true) break;", (PsiElement)whileStatement);
            ifStatement = (PsiIfStatement)codeBlock.addAfter((PsiElement)ifStatement, (PsiElement)codeBlock.getLBrace());
            PsiPrefixExpression negation = (PsiPrefixExpression)Objects.requireNonNull(ifStatement.getCondition());
            Objects.requireNonNull(negation.getOperand()).replace((PsiElement)rOperands);
            Objects.requireNonNull(whileStatement.getCondition()).replace((PsiElement)lOperands);
            return ifStatement;
        }
    }

    private static class SplitTrySurrounder
    extends CodeBlockSurrounder {
        private final PsiResourceVariable myVariable;
        private final PsiTryStatement myStatement;

        SplitTrySurrounder(@NotNull PsiExpression expression2, @NotNull PsiResourceVariable variable, @NotNull PsiTryStatement tryStatement) {
            super(expression2);
            this.myVariable = variable;
            this.myStatement = tryStatement;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            PsiResourceList list = Objects.requireNonNull(this.myStatement.getResourceList());
            PsiTryStatement copy = (PsiTryStatement)this.myStatement.copy();
            PsiResourceList copyList = copy.getResourceList();
            if (copyList == null) {
                return this.myStatement;
            }
            PsiCodeBlock tryBlock = this.myStatement.getTryBlock();
            if (tryBlock == null) {
                return this.myStatement;
            }
            List elementsToMove = ((StreamEx)StreamEx.of((Iterator)list.iterator()).dropWhile(e -> e != this.myVariable)).toList();
            for (PsiCatchSection[] element : elementsToMove) {
                element.delete();
            }
            for (PsiCatchSection[] element : ((StreamEx)StreamEx.of((Iterator)copyList.iterator()).limit((long)(copyList.getResourceVariablesCount() - elementsToMove.size()))).toList()) {
                element.delete();
            }
            PsiElement[] children = copyList.getChildren();
            if (children[0].textMatches((CharSequence)"(") && children[1] instanceof PsiWhiteSpace) {
                children[1].delete();
            }
            for (PsiCatchSection section : copy.getCatchSections()) {
                section.delete();
            }
            PsiCodeBlock copyFinally = copy.getFinallyBlock();
            if (copyFinally != null) {
                PsiElement element = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)copyFinally);
                if (element != null && element.textMatches((CharSequence)"finally")) {
                    element.delete();
                }
                copyFinally.delete();
            }
            PsiElement codeBlock = tryBlock.replace((PsiElement)factory.createCodeBlock());
            return (PsiStatement)codeBlock.add((PsiElement)copy);
        }
    }

    private static class ExtractFieldInitializerSurrounder
    extends CodeBlockSurrounder {
        private final PsiField myField;

        public ExtractFieldInitializerSurrounder(@NotNull PsiExpression expression2, @NotNull PsiField field) {
            super(expression2);
            this.myField = field;
        }

        @Override
        @NotNull
        public ParentContext getExpectedParentContext() {
            return this.myField.getInitializer() == this.myExpression ? ParentContext.ASSIGNMENT : super.getExpectedParentContext();
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            this.myField.normalizeDeclaration();
            PsiClassInitializer initializer = (PsiClassInitializer)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)this.myField), PsiClassInitializer.class);
            boolean isStatic = this.myField.hasModifierProperty("static");
            if (initializer == null || initializer.hasModifierProperty("static") != isStatic) {
                initializer = factory.createClassInitializer();
                if (isStatic) {
                    Objects.requireNonNull(initializer.getModifierList()).setModifierProperty("static", true);
                }
                initializer = (PsiClassInitializer)this.myField.getParent().addAfter((PsiElement)initializer, (PsiElement)this.myField);
            }
            PsiCodeBlock body2 = initializer.getBody();
            PsiElement anchor = PsiTreeUtil.skipWhitespacesForward((PsiElement)body2.getFirstChild());
            assert (anchor != null);
            anchor = anchor.getPrevSibling();
            assert (anchor != null);
            PsiExpressionStatement assignment = (PsiExpressionStatement)factory.createStatementFromText(this.myField.getName() + "=null;", (PsiElement)initializer);
            assignment = (PsiExpressionStatement)body2.addAfter((PsiElement)assignment, anchor);
            PsiExpression fieldInitializer = this.myField.getInitializer();
            fieldInitializer = ExpressionUtils.convertInitializerToExpression(fieldInitializer, factory, this.myField.getType());
            PsiExpression rExpression = ((PsiAssignmentExpression)assignment.getExpression()).getRExpression();
            assert (fieldInitializer != null);
            assert (rExpression != null);
            rExpression.replace((PsiElement)fieldInitializer);
            Objects.requireNonNull(this.myField.getInitializer()).delete();
            return assignment;
        }
    }

    private static class SimpleSurrounder
    extends CodeBlockSurrounder {
        private final PsiStatement myStatement;

        SimpleSurrounder(PsiExpression expression2, PsiStatement statement) {
            super(expression2);
            this.myStatement = statement;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            PsiBlockStatement block = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)this.myStatement);
            block.getCodeBlock().add((PsiElement)this.myStatement);
            block = (PsiBlockStatement)this.myStatement.replace((PsiElement)block);
            return block.getCodeBlock().getStatements()[0];
        }
    }

    private static class YieldSurrounder
    extends CodeBlockSurrounder {
        private final PsiExpressionStatement myStatement;

        YieldSurrounder(PsiExpression expression2, PsiExpressionStatement statement) {
            super(expression2);
            this.myStatement = statement;
        }

        @Override
        @NotNull
        public ParentContext getExpectedParentContext() {
            return this.myExpression.getParent() == this.myStatement ? ParentContext.RETURN : super.getExpectedParentContext();
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            PsiBlockStatement block = (PsiBlockStatement)factory.createStatementFromText("{yield x;}", (PsiElement)this.myStatement);
            PsiExpression newExpression = Objects.requireNonNull(((PsiYieldStatement)block.getCodeBlock().getStatements()[0]).getExpression());
            newExpression.replace((PsiElement)this.myStatement.getExpression());
            block = (PsiBlockStatement)this.myStatement.replace((PsiElement)block);
            return block.getCodeBlock().getStatements()[0];
        }
    }

    private static class LambdaCodeBlockSurrounder
    extends CodeBlockSurrounder {
        @NotNull
        private final PsiLambdaExpression myLambda;
        private final boolean myVoidMode;

        LambdaCodeBlockSurrounder(@NotNull PsiExpression expression2, @NotNull PsiLambdaExpression lambda2) {
            super(expression2);
            this.myLambda = lambda2;
            this.myVoidMode = PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)this.myLambda));
        }

        @Override
        @NotNull
        public ParentContext getExpectedParentContext() {
            PsiElement parent = this.myExpression.getParent();
            if (parent == this.myLambda) {
                return this.myVoidMode ? ParentContext.EXPRESSION : ParentContext.RETURN;
            }
            return super.getExpectedParentContext();
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            String replacementText = this.myVoidMode ? "{a;}" : "{return a;}";
            PsiCodeBlock newBody = factory.createCodeBlockFromText(replacementText, (PsiElement)this.myLambda);
            LambdaUtil.extractSingleExpressionFromBody((PsiElement)newBody).replace(Objects.requireNonNull(this.myLambda.getBody()));
            newBody = (PsiCodeBlock)this.myLambda.getBody().replace((PsiElement)newBody);
            return newBody.getStatements()[0];
        }
    }

    private static class NoOpSurrounder
    extends CodeBlockSurrounder {
        private final PsiStatement myAnchor;

        NoOpSurrounder(@NotNull PsiExpression expression2, @NotNull PsiStatement anchor) {
            super(expression2);
            this.myAnchor = anchor;
        }

        @Override
        @NotNull
        public SurroundResult surround() {
            return new SurroundResult(this.myExpression, this.myAnchor);
        }
    }

    public static class SurroundResult {
        @NotNull
        private final PsiExpression myExpression;
        @NotNull
        private final PsiStatement myAnchor;

        SurroundResult(@NotNull PsiExpression expression2, @NotNull PsiStatement anchor) {
            this.myExpression = expression2;
            this.myAnchor = anchor;
        }

        @NotNull
        public PsiExpression getExpression() {
            return this.myExpression;
        }

        @NotNull
        public PsiStatement getAnchor() {
            return this.myAnchor;
        }
    }

    private static enum ParentContext {
        RETURN,
        ASSIGNMENT,
        EXPRESSION,
        SIMPLE_IF_CONDITION,
        UNKNOWN;

    }
}

