/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ObjectAllocationInLoopInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Kind kind2 = (Kind)((Object)infos[0]);
        return kind2.toString();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectAllocationInLoopsVisitor();
    }

    private static class ObjectAllocationInLoopsVisitor
    extends BaseInspectionVisitor {
        private ObjectAllocationInLoopsVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            PsiMethod method = call.resolveMethod();
            if (method != null) {
                List<StandardMethodContract> contracts2 = JavaMethodContractUtil.getMethodContracts(method);
                ContractReturnValue value2 = JavaMethodContractUtil.getNonFailingReturnValue(contracts2);
                if (ContractReturnValue.returnNew().equals(value2) && ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)call)) {
                    this.registerMethodCallError(call, new Object[]{Kind.METHOD_CALL});
                }
            }
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            if (!(expression2.getParent() instanceof PsiNewExpression) && !(expression2.getParent() instanceof PsiArrayInitializerExpression) && ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)expression2)) {
                this.registerError((PsiElement)expression2, new Object[]{Kind.ARRAY_INITIALIZER});
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            super.visitMethodReferenceExpression(expression2);
            if (!PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)expression2) && ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)expression2)) {
                this.registerError((PsiElement)expression2, new Object[]{Kind.METHOD_REFERENCE});
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression lambda2) {
            super.visitLambdaExpression(lambda2);
            if (ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)lambda2) && LambdaUtil.isCapturingLambda((PsiLambdaExpression)lambda2)) {
                this.registerError((PsiElement)lambda2.getParameterList(), new Object[]{Kind.CAPTURING_LAMBDA});
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)expression2)) {
                this.registerNewExpressionError(expression2, new Object[]{expression2.isArrayCreation() ? Kind.ARRAY_INITIALIZER : Kind.NEW_OPERATOR});
            }
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            IElementType type2 = expression2.getOperationTokenType();
            if (JavaTokenType.PLUS.equals(type2) && TypeUtils.isJavaLangString(expression2.getType()) && !PsiUtil.isConstantExpression((PsiExpression)expression2) && ObjectAllocationInLoopsVisitor.isPerformedRepeatedlyInLoop((PsiExpression)expression2)) {
                this.registerError((PsiElement)expression2, new Object[]{Kind.STRING_CONCAT});
            }
            super.visitPolyadicExpression(expression2);
        }

        private static boolean isPerformedRepeatedlyInLoop(@NotNull PsiExpression expression2) {
            if (!ControlFlowUtils.isInLoop((PsiElement)expression2)) {
                return false;
            }
            if (ControlFlowUtils.isInExitStatement(expression2)) {
                return false;
            }
            PsiStatement newExpressionStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class);
            if (newExpressionStatement == null) {
                return false;
            }
            PsiStatement parentStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)newExpressionStatement, PsiStatement.class);
            if (!ControlFlowUtils.statementMayCompleteNormally(parentStatement)) {
                return false;
            }
            return !ObjectAllocationInLoopsVisitor.isAllocatedOnlyOnce(expression2);
        }

        private static boolean isAllocatedOnlyOnce(PsiExpression expression2) {
            boolean equals;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiAssignmentExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            if (assignment == null) {
                return false;
            }
            PsiReferenceExpression assignedRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
            if (assignedRef == null) {
                return false;
            }
            if (assignment.getRExpression() != expression2 && NullabilityUtil.getExpressionNullability(assignment.getRExpression()) != Nullability.NOT_NULL) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)assignment, PsiIfStatement.class);
            if (ifStatement == null) {
                return false;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)ifStatement.getThenBranch(), (PsiElement)assignment, (boolean)true)) {
                equals = true;
            } else if (PsiTreeUtil.isAncestor((PsiElement)ifStatement.getElseBranch(), (PsiElement)assignment, (boolean)true)) {
                equals = false;
            } else {
                return false;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            PsiReferenceExpression nullCheckedRef = ExpressionUtils.getReferenceExpressionFromNullComparison(condition2, equals);
            return nullCheckedRef != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nullCheckedRef, (PsiElement)assignedRef);
        }
    }

    static enum Kind {
        NEW_OPERATOR("object.allocation.in.loop.new.descriptor"),
        METHOD_CALL("object.allocation.in.loop.problem.call.descriptor"),
        METHOD_REFERENCE("object.allocation.in.loop.problem.methodref.descriptor"),
        CAPTURING_LAMBDA("object.allocation.in.loop.problem.lambda.descriptor"),
        STRING_CONCAT("object.allocation.in.loop.problem.string.concat"),
        ARRAY_INITIALIZER("object.allocation.in.loop.problem.array.initializer.descriptor");

        private final String myMessage;

        private Kind(String message2) {
            this.myMessage = InspectionGadgetsBundle.message(message2, new Object[0]);
        }

        public String toString() {
            return this.myMessage;
        }
    }
}

