/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageWithTooFewClassesInspection
extends BaseGlobalInspection {
    public int limit = 3;

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        List children = refEntity.getChildren();
        int numClasses = 0;
        boolean subpackage = false;
        for (RefEntity child : children) {
            if (child instanceof RefClass) {
                ++numClasses;
                continue;
            }
            if (!(child instanceof RefPackage)) continue;
            subpackage = true;
        }
        if (numClasses >= this.limit || numClasses == 0 && subpackage) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("package.with.too.few.classes.problem.descriptor", refEntity.getQualifiedName(), numClasses, this.limit);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("package.with.too.few.classes.min.option", new Object[0]), (InspectionProfileEntry)this, "limit");
    }
}

