/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.numeric.ConvertOctalLiteralToDecimalFix;
import com.siyeh.ig.numeric.RemoveLeadingZeroFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class OctalLiteralInspection
extends BaseInspection {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "OctalInteger";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("octal.literal.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        return new InspectionGadgetsFix[]{new ConvertOctalLiteralToDecimalFix(), new RemoveLeadingZeroFix()};
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OctalLiteralVisitor();
    }

    private static class OctalLiteralVisitor
    extends BaseInspectionVisitor {
        private OctalLiteralVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
            super.visitLiteralExpression(literal);
            if (!ExpressionUtils.isOctalLiteral(literal)) {
                return;
            }
            this.registerError((PsiElement)literal, new Object[0]);
        }
    }
}

