/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DivideByZeroInspection
extends BaseInspection {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "divzero";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("divide.by.zero.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiType type2;
        PsiBinaryExpression binOp;
        if (infos.length > 0 && infos[0] instanceof PsiBinaryExpression && (binOp = (PsiBinaryExpression)infos[0]).getOperationTokenType().equals(JavaTokenType.DIV) && DivideByZeroInspection.isZero(binOp.getLOperand()) && (PsiType.DOUBLE.equals((Object)(type2 = binOp.getType())) || PsiType.FLOAT.equals((Object)type2))) {
            return new ReplaceWithNaNFix();
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DivisionByZeroVisitor();
    }

    private static boolean isZero(PsiExpression expression2) {
        Object value2 = ConstantExpressionUtil.computeCastTo((PsiExpression)expression2, (PsiType)PsiType.DOUBLE);
        if (value2 instanceof Double) {
            double constantValue = (Double)value2;
            return constantValue == 0.0;
        }
        DfType dfType = CommonDataflow.getDfType(expression2);
        Number val = DfConstantType.getConstantOfType(dfType, Number.class);
        return val != null && val.doubleValue() == 0.0;
    }

    private static class ReplaceWithNaNFix
    extends InspectionGadgetsFix {
        private ReplaceWithNaNFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiBinaryExpression division = (PsiBinaryExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)descriptor.getStartElement(), (Class[])new Class[]{PsiBinaryExpression.class});
            if (division == null) {
                return;
            }
            PsiType type2 = division.getType();
            if (!(type2 instanceof PsiPrimitiveType)) {
                return;
            }
            String className2 = ((PsiPrimitiveType)type2).getBoxedTypeName();
            new CommentTracker().replaceAndRestoreComments((PsiElement)division, className2 + ".NaN");
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"NaN"});
        }
    }

    private static class DivisionByZeroVisitor
    extends BaseInspectionVisitor {
        private DivisionByZeroVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!JavaTokenType.DIV.equals(tokenType) && !JavaTokenType.PERC.equals(tokenType)) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            for (int i = 1; i < operands2.length; ++i) {
                PsiExpression operand2 = operands2[i];
                if (!DivideByZeroInspection.isZero(operand2)) continue;
                this.registerError((PsiElement)operand2, expression2);
                return;
            }
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            PsiExpression rhs = expression2.getRExpression();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.DIVEQ) && !tokenType.equals(JavaTokenType.PERCEQ) || !DivideByZeroInspection.isZero(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }
}

