/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ComparisonToNaNInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiBinaryExpression comparison = (PsiBinaryExpression)infos[0];
        IElementType tokenType = comparison.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.NE)) {
            return InspectionGadgetsBundle.message("comparison.to.nan.problem.descriptor2", new Object[0]);
        }
        return InspectionGadgetsBundle.message("comparison.to.nan.problem.descriptor1", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ComparisonToNaNVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiBinaryExpression comparison = (PsiBinaryExpression)infos[0];
        return ComparisonUtils.isEqualityComparison((PsiExpression)comparison) ? new ComparisonToNaNFix() : null;
    }

    private static class ComparisonToNaNVisitor
    extends BaseInspectionVisitor {
        private ComparisonToNaNVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            if (!ComparisonUtils.isComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null || !TypeUtils.hasFloatingPointType(lhs) && !TypeUtils.hasFloatingPointType(rhs)) {
                return;
            }
            if (ComparisonToNaNVisitor.isNaN(lhs)) {
                this.registerError((PsiElement)lhs, expression2);
            } else if (ComparisonToNaNVisitor.isNaN(rhs)) {
                this.registerError((PsiElement)rhs, expression2);
            }
        }

        private static boolean isNaN(PsiExpression expression2) {
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            String referenceName = referenceExpression.getReferenceName();
            if (!"NaN".equals(referenceName)) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String qualifiedName = containingClass.getQualifiedName();
            return "java.lang.Double".equals(qualifiedName) || "java.lang.Float".equals(qualifiedName);
        }
    }

    private static class ComparisonToNaNFix
    extends InspectionGadgetsFix {
        private ComparisonToNaNFix() {
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"isNaN()"});
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiReferenceExpression nanExpression = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiElement target = nanExpression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String typeText = containingClass.getQualifiedName();
            PsiBinaryExpression comparison = (PsiBinaryExpression)nanExpression.getParent();
            PsiExpression lhs = comparison.getLOperand();
            PsiExpression rhs = comparison.getROperand();
            PsiExpression operand2 = nanExpression.equals(lhs) ? rhs : lhs;
            assert (operand2 != null);
            CommentTracker commentTracker = new CommentTracker();
            String operandText = commentTracker.text((PsiElement)operand2);
            IElementType tokenType = comparison.getOperationTokenType();
            String negationText = tokenType.equals(JavaTokenType.EQEQ) ? "" : "!";
            String newExpressionText = negationText + typeText + ".isNaN(" + operandText + ')';
            PsiReplacementUtil.replaceExpression((PsiExpression)comparison, newExpressionText, commentTracker);
        }
    }
}

