/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.migration.ForCanBeForeachInspection;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhileCanBeForeachInspection
extends BaseInspection {
    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new WhileCanBeForeachFix();
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "WhileLoopReplaceableByForEach";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("while.can.be.foreach.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileCanBeForeachVisitor();
    }

    @Nullable
    static PsiStatement getPreviousStatement(PsiElement context) {
        PsiElement prevStatement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)context);
        if (!(prevStatement instanceof PsiStatement)) {
            return null;
        }
        return (PsiStatement)prevStatement;
    }

    private static class WhileCanBeForeachVisitor
    extends BaseInspectionVisitor {
        private WhileCanBeForeachVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement whileStatement) {
            super.visitWhileStatement(whileStatement);
            if (!WhileCanBeForeachVisitor.isCollectionLoopStatement(whileStatement)) {
                return;
            }
            this.registerStatementError((PsiStatement)whileStatement, new Object[0]);
        }

        private static boolean isCollectionLoopStatement(PsiWhileStatement whileStatement) {
            PsiStatement initialization = WhileCanBeForeachInspection.getPreviousStatement((PsiElement)whileStatement);
            PsiVariable variable = ForCanBeForeachInspection.getIterableVariable(initialization, false);
            if (variable == null) {
                return false;
            }
            PsiExpression condition2 = whileStatement.getCondition();
            if (!ForCanBeForeachInspection.isHasNext(condition2, variable)) {
                return false;
            }
            if (!ForCanBeForeachInspection.hasSimpleNextCall(variable, (PsiElement)whileStatement.getBody())) {
                return false;
            }
            for (PsiElement nextSibling = whileStatement.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
                if (!VariableAccessUtils.variableValueIsUsed(variable, nextSibling)) continue;
                return false;
            }
            return true;
        }
    }

    private static class WhileCanBeForeachFix
    extends InspectionGadgetsFix {
        private WhileCanBeForeachFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("foreach.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement whileElement = descriptor.getPsiElement();
            PsiWhileStatement whileStatement = (PsiWhileStatement)whileElement.getParent();
            WhileCanBeForeachFix.replaceWhileWithForEach(whileStatement);
        }

        private static void replaceWhileWithForEach(@NotNull PsiWhileStatement whileStatement) {
            PsiDeclarationStatement statementToSkip;
            String contentVariableName;
            PsiStatement body2 = whileStatement.getBody();
            if (body2 == null) {
                return;
            }
            PsiStatement initialization = WhileCanBeForeachInspection.getPreviousStatement((PsiElement)whileStatement);
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)initialization;
            if (declaration2 == null) {
                return;
            }
            PsiElement declaredElement = declaration2.getDeclaredElements()[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable iterator = (PsiLocalVariable)declaredElement;
            PsiMethodCallExpression initializer = (PsiMethodCallExpression)PsiUtil.skipParenthesizedExprDown((PsiExpression)iterator.getInitializer());
            if (initializer == null) {
                return;
            }
            PsiReferenceExpression methodExpression = initializer.getMethodExpression();
            PsiExpression collection = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getEffectiveQualifier(methodExpression));
            if (collection == null) {
                return;
            }
            PsiType collectionType = collection.getType();
            if (collectionType == null) {
                return;
            }
            PsiType contentType = ForCanBeForeachInspection.getContentType(collectionType, "java.lang.Iterable");
            if (contentType == null) {
                return;
            }
            PsiType iteratorContentType = ForCanBeForeachInspection.getContentType(iterator.getType(), "java.util.Iterator");
            if (TypeUtils.isJavaLangObject(iteratorContentType)) {
                iteratorContentType = ForCanBeForeachInspection.getContentType(initializer.getType(), "java.util.Iterator");
            }
            if (iteratorContentType == null) {
                return;
            }
            PsiStatement firstStatement = ForCanBeForeachInspection.getFirstStatement(body2);
            boolean isDeclaration = ForCanBeForeachInspection.isIteratorNextDeclaration(firstStatement, (PsiVariable)iterator, contentType);
            if (isDeclaration) {
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)firstStatement;
                PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                PsiLocalVariable localVariable = (PsiLocalVariable)declaredElements[0];
                contentVariableName = localVariable.getName();
                iteratorContentType = localVariable.getType();
                statementToSkip = declarationStatement;
            } else {
                if (collection instanceof PsiReferenceExpression) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)collection;
                    String collectionName = referenceElement.getReferenceName();
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)whileStatement, iteratorContentType, collectionName);
                } else {
                    contentVariableName = ForCanBeForeachInspection.createNewVariableName((PsiElement)whileStatement, iteratorContentType, null);
                }
                statementToSkip = null;
            }
            CommentTracker ct = new CommentTracker();
            StringBuilder newStatement = new StringBuilder();
            newStatement.append("for(");
            if (JavaCodeStyleSettings.getInstance((PsiFile)whileStatement.getContainingFile()).GENERATE_FINAL_PARAMETERS) {
                newStatement.append("final ");
            }
            String canonicalText = iteratorContentType.getCanonicalText();
            newStatement.append(canonicalText).append(' ').append(contentVariableName).append(": ");
            if (!TypeConversionUtil.isAssignable((PsiType)iteratorContentType, (PsiType)contentType)) {
                newStatement.append("(java.lang.Iterable<").append(canonicalText).append(">)");
            }
            newStatement.append(ct.text((PsiElement)collection)).append(')');
            ForCanBeForeachInspection.replaceIteratorNext((PsiElement)body2, contentVariableName, (PsiVariable)iterator, contentType, (PsiElement)statementToSkip, ct, newStatement);
            Query query = ReferencesSearch.search((PsiElement)iterator);
            boolean deleteIterator = true;
            for (PsiReference usage : query) {
                PsiElement element = usage.getElement();
                if (PsiTreeUtil.isAncestor((PsiElement)whileStatement, (PsiElement)element, (boolean)true)) continue;
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAssignmentExpression.class);
                if (assignment == null) {
                    deleteIterator = false;
                    break;
                }
                PsiExpression expression2 = assignment.getRExpression();
                PsiTypeElement typeElement = iterator.getTypeElement();
                if (typeElement.isInferredType() && (expression2 == null || PsiType.NULL.equals((Object)expression2.getType()) || expression2 instanceof PsiArrayInitializerExpression || expression2 instanceof PsiFunctionalExpression) && PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement) == null) {
                    deleteIterator = false;
                    break;
                }
                iterator.setInitializer(expression2);
                PsiElement statement = assignment.getParent();
                PsiElement lastChild = statement.getLastChild();
                if (lastChild instanceof PsiComment) {
                    iterator.add(lastChild);
                }
                statement.replace((PsiElement)iterator);
                break;
            }
            if (deleteIterator) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)iterator);
            }
            ct.replaceAndRestoreComments((PsiElement)whileStatement, newStatement.toString());
        }
    }
}

