/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiBoxingUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryBoxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyBoxed = false;

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.boxing.superfluous.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportSuperfluouslyBoxed");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos.length == 0) {
            return InspectionGadgetsBundle.message("unnecessary.boxing.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("unnecessary.boxing.inside.value.of.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return infos.length == 0 ? new UnnecessaryBoxingFix() : new UnnecessaryBoxingFix((PsiType)infos[0]);
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBoxingVisitor();
    }

    @Nullable
    private static String getParseMethod(@Nullable PsiType type2) {
        if (type2 == null) {
            return null;
        }
        String typeText = type2.getCanonicalText();
        return JavaPsiBoxingUtils.getParseMethod(typeText);
    }

    private class UnnecessaryBoxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBoxingVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            PsiType expectedType;
            super.visitNewExpression(expression2);
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiType constructorType = expression2.getType();
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)constructorType);
            if (unboxedType == null) {
                return;
            }
            PsiMethod constructor = expression2.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            PsiType argumentType = boxedExpression.getType();
            if (!(argumentType instanceof PsiPrimitiveType) || this.isBoxingNecessary((PsiExpression)expression2, boxedExpression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiType expectedType;
            super.visitMethodCallExpression(expression2);
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"valueOf".equals(referenceName)) {
                return;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodExpression.resolve(), PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String canonicalText = aClass.getQualifiedName();
            if (canonicalText == null || !TypeConversionUtil.isPrimitiveWrapper((String)canonicalText)) {
                return;
            }
            PsiType boxedExpressionType = boxedExpression.getType();
            if (TypeUtils.isJavaLangString(boxedExpressionType)) {
                PsiType expectedType2 = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, false, true);
                PsiType methodReturnType = method.getReturnType();
                if (expectedType2 instanceof PsiPrimitiveType && UnnecessaryBoxingInspection.getParseMethod(methodReturnType) != null) {
                    this.registerError((PsiElement)expression2, methodReturnType);
                }
                return;
            }
            if (!(boxedExpressionType instanceof PsiPrimitiveType)) {
                return;
            }
            if (this.isBoxingNecessary((PsiExpression)expression2, boxedExpression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private boolean isBoxingNecessary(PsiExpression boxingExpression, PsiExpression boxedExpression) {
            if (ExpressionUtils.isVoidContext(boxingExpression)) {
                return true;
            }
            PsiElement parent = boxingExpression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                boxingExpression = (PsiExpression)parent;
                parent = parent.getParent();
            }
            if (parent instanceof PsiReferenceExpression || parent instanceof PsiSynchronizedStatement) {
                return true;
            }
            if (parent instanceof PsiVariable) {
                PsiTypeElement typeElement = ((PsiVariable)parent).getTypeElement();
                if (typeElement != null && typeElement.isInferredType()) {
                    return true;
                }
            } else {
                if (parent instanceof PsiTypeCastExpression) {
                    PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                    return TypeUtils.isTypeParameter(castExpression.getType());
                }
                if (parent instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                    PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
                    PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
                    if (elseExpression2 == null || thenExpression2 == null) {
                        return true;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)thenExpression2, (PsiElement)boxingExpression, (boolean)false)) {
                        PsiType type2 = elseExpression2.getType();
                        return !(type2 instanceof PsiPrimitiveType);
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)elseExpression2, (PsiElement)boxingExpression, (boolean)false)) {
                        PsiType type3 = thenExpression2.getType();
                        return !(type3 instanceof PsiPrimitiveType);
                    }
                    return false;
                }
                if (parent instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                    return this.isPossibleObjectComparison(boxingExpression, polyadicExpression);
                }
            }
            return MethodCallUtils.isNecessaryForSurroundingMethodCall(boxingExpression, boxedExpression) || !LambdaUtil.isSafeLambdaReturnValueReplacement((PsiExpression)boxingExpression, (PsiExpression)boxedExpression);
        }

        private boolean isPossibleObjectComparison(PsiExpression expression2, PsiPolyadicExpression polyadicExpression) {
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                return false;
            }
            for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                if (operand2 == expression2 || operand2.getType() instanceof PsiPrimitiveType) continue;
                return true;
            }
            return false;
        }
    }

    private static class UnnecessaryBoxingFix
    extends InspectionGadgetsFix {
        private final String name;

        private UnnecessaryBoxingFix() {
            this.name = InspectionGadgetsBundle.message("unnecessary.boxing.remove.quickfix", new Object[0]);
        }

        private UnnecessaryBoxingFix(PsiType retType) {
            this.name = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{UnnecessaryBoxingInspection.getParseMethod(retType)});
        }

        @NotNull
        public String getFamilyName() {
            return this.name;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) {
            String replacementText;
            PsiCallExpression expression2 = (PsiCallExpression)descriptor.getPsiElement();
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression unboxedExpression = arguments[0];
            PsiType unboxedExpressionType = unboxedExpression.getType();
            if (unboxedExpressionType == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            if (unboxedExpressionType.getCanonicalText().equals("java.lang.String")) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
                String parseMethodName = UnnecessaryBoxingInspection.getParseMethod(methodCall.getType());
                if (parseMethodName == null) {
                    return;
                }
                ExpressionUtils.bindCallTo(methodCall, parseMethodName);
                return;
            }
            Object value2 = ExpressionUtils.computeConstantExpression(unboxedExpression);
            if (value2 != null) {
                if (value2 == Boolean.TRUE) {
                    PsiReplacementUtil.replaceExpression((PsiExpression)expression2, "java.lang.Boolean.TRUE", commentTracker);
                    return;
                }
                if (value2 == Boolean.FALSE) {
                    PsiReplacementUtil.replaceExpression((PsiExpression)expression2, "java.lang.Boolean.FALSE", commentTracker);
                    return;
                }
            }
            if ((replacementText = UnnecessaryBoxingFix.getUnboxedExpressionText(unboxedExpression, (PsiExpression)expression2, commentTracker)) == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, replacementText, commentTracker);
        }

        @Nullable
        private static String getUnboxedExpressionText(@NotNull PsiExpression unboxedExpression, @NotNull PsiExpression boxedExpression, CommentTracker commentTracker) {
            PsiType boxedType = boxedExpression.getType();
            if (boxedType == null) {
                return null;
            }
            PsiType expressionType = unboxedExpression.getType();
            if (expressionType == null) {
                return null;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)boxedType);
            if (unboxedType == null) {
                return null;
            }
            String text2 = commentTracker.text((PsiElement)unboxedExpression);
            if (expressionType.equals(unboxedType)) {
                PsiElement parent = boxedExpression.getParent();
                if (parent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(unboxedExpression, (PsiExpression)parent, false)) {
                    return '(' + text2 + ')';
                }
                return text2;
            }
            if (unboxedExpression instanceof PsiLiteralExpression) {
                if (unboxedType.equals(PsiType.LONG) && expressionType.equals(PsiType.INT)) {
                    return text2 + 'L';
                }
                if (!text2.startsWith("0")) {
                    if (unboxedType.equals(PsiType.FLOAT) && (expressionType.equals(PsiType.INT) || expressionType.equals(PsiType.DOUBLE) && !StringUtil.endsWithIgnoreCase((String)text2, (String)"d"))) {
                        return text2 + 'f';
                    }
                    if (unboxedType.equals(PsiType.DOUBLE) && expressionType.equals(PsiType.INT)) {
                        return text2 + 'd';
                    }
                }
            }
            if (ParenthesesUtils.getPrecedence(unboxedExpression) > 4) {
                return '(' + unboxedType.getCanonicalText() + ")(" + text2 + ')';
            }
            return '(' + unboxedType.getCanonicalText() + ')' + text2;
        }
    }
}

