/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceConstantFix;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class ZeroLengthArrayInitializationInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntroduceConstantFix();
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ZeroLengthArrayAllocation";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("array.allocation.zero.length.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ZeroLengthArrayInitializationVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private static class ZeroLengthArrayInitializationVisitor
    extends BaseInspectionVisitor {
        private ZeroLengthArrayInitializationVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (!ConstructionUtils.isEmptyArrayInitializer((PsiExpression)expression2)) {
                return;
            }
            if (ExpressionUtils.isDeclaredConstant((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            super.visitArrayInitializerExpression(expression2);
            PsiExpression[] initializers = expression2.getInitializers();
            if (initializers.length > 0) {
                return;
            }
            if (expression2.getParent() instanceof PsiNewExpression) {
                return;
            }
            if (ExpressionUtils.isDeclaredConstant((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }
}

