/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.JUnit4AnnotatedMethodInJUnit3TestCaseInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Junit4ConverterInspection
extends BaseInspection {
    @Override
    public boolean shouldInspect(PsiFile file) {
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)file)) {
            return true;
        }
        return super.shouldInspect(file);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("convert.junit3.test.case.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitClass(PsiClass aClass) {
                super.visitClass(aClass);
                if (this.possibleToConvert(aClass)) {
                    this.registerClassError(aClass, new Object[0]);
                }
            }

            private boolean possibleToConvert(PsiClass aClass) {
                PsiReferenceList extendsList = aClass.getExtendsList();
                if (extendsList == null) {
                    return false;
                }
                PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
                if (referenceElements.length != 1) {
                    return false;
                }
                PsiJavaCodeReferenceElement referenceElement = referenceElements[0];
                PsiElement target = referenceElement.resolve();
                if (!(target instanceof PsiClass)) {
                    return false;
                }
                PsiClass targetClass = (PsiClass)target;
                String name2 = targetClass.getQualifiedName();
                if (!"junit.framework.TestCase".equals(name2)) {
                    return false;
                }
                Project project = aClass.getProject();
                GlobalSearchScope scope = aClass.getResolveScope();
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                PsiClass testAnnotation = psiFacade.findClass("org.junit.Test", scope);
                return testAnnotation != null;
            }
        };
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InspectionGadgetsFix(){

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) {
                PsiClass pClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
                JUnit4AnnotatedMethodInJUnit3TestCaseInspection.convertJUnit3ClassToJUnit4(pClass);
            }

            @NotNull
            public String getFamilyName() {
                return InspectionGadgetsBundle.message("convert.junit3.test.case.family.name", new Object[0]);
            }
        };
    }
}

