/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class SimpleDateFormatWithoutLocaleInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("instantiating.simpledateformat.without.locale.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimpleDateFormatWithoutLocaleVisitor();
    }

    private static class SimpleDateFormatWithoutLocaleVisitor
    extends BaseInspectionVisitor {
        private SimpleDateFormatWithoutLocaleVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            PsiExpression[] arguments;
            super.visitNewExpression(expression2);
            if (!ExpressionUtils.hasType((PsiExpression)expression2, "java.text.SimpleDateFormat")) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                if (!ExpressionUtils.hasType(argument, "java.util.Locale")) continue;
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }
    }
}

