/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InheritanceUtil;
import org.jetbrains.annotations.NotNull;

public class AbstractClassNeverImplementedInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("abstract.class.never.implemented.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractClassNeverImplementedVisitor();
    }

    private static class AbstractClassNeverImplementedVisitor
    extends BaseInspectionVisitor {
        private AbstractClassNeverImplementedVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                return;
            }
            if (InheritanceUtil.hasImplementation(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

