/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class AbstractClassExtendsConcreteClassInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("abstract.class.extends.concrete.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractClassExtendsConcreteClassVisitor();
    }

    private static class AbstractClassExtendsConcreteClassVisitor
    extends BaseInspectionVisitor {
        private AbstractClassExtendsConcreteClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!aClass.hasModifierProperty("abstract")) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            if (superClass.hasModifierProperty("abstract")) {
                return;
            }
            String superclassName = superClass.getQualifiedName();
            if ("java.lang.Object".equals(superclassName)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

