/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IgnoreClassFix
extends InspectionGadgetsFix
implements LowPriorityAction {
    final Collection<? super String> myIgnoredClasses;
    final String myQualifiedName;
    private final String myFixName;

    public IgnoreClassFix(String qualifiedName, Collection<? super String> ignoredClasses, String fixName) {
        this.myIgnoredClasses = ignoredClasses;
        this.myQualifiedName = qualifiedName;
        this.myFixName = fixName;
    }

    @Nls
    @NotNull
    public String getName() {
        return this.myFixName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("ignore.class.fix.family.name", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void doFix(final Project project, ProblemDescriptor descriptor) {
        if (!this.myIgnoredClasses.add(this.myQualifiedName)) {
            return;
        }
        ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)descriptor.getPsiElement());
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{vFile}){

            public void undo() {
                IgnoreClassFix.this.myIgnoredClasses.remove(IgnoreClassFix.this.myQualifiedName);
                ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
            }

            public void redo() {
                IgnoreClassFix.this.myIgnoredClasses.add(IgnoreClassFix.this.myQualifiedName);
                ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
            }

            public boolean isGlobal() {
                return true;
            }
        });
    }
}

