/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.exceptions;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiCatchCanBeSplitInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.getDisplayName();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SplitMultiCatchVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SplitMultiCatchFix();
    }

    private static void doFixImpl(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiCatchSection)) {
            return;
        }
        PsiCatchSection catchSection = (PsiCatchSection)parent;
        PsiElement grandParent = catchSection.getParent();
        if (!(grandParent instanceof PsiTryStatement)) {
            return;
        }
        PsiParameter parameter2 = catchSection.getParameter();
        if (parameter2 == null) {
            return;
        }
        PsiType type2 = parameter2.getType();
        if (!(type2 instanceof PsiDisjunctionType)) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)element.getProject());
        for (PsiType disjunction : ((PsiDisjunctionType)type2).getDisjunctions()) {
            PsiCatchSection copy = (PsiCatchSection)catchSection.copy();
            PsiTypeElement typeElement = Objects.requireNonNull(Objects.requireNonNull(copy.getParameter()).getTypeElement());
            PsiTypeElement newTypeElement = factory.createTypeElementFromText(disjunction.getCanonicalText(true), (PsiElement)catchSection);
            PsiElement replaced = typeElement.replace((PsiElement)newTypeElement);
            grandParent.addBefore((PsiElement)copy, (PsiElement)catchSection);
            styleManager.shortenClassReferences(replaced);
        }
        catchSection.delete();
    }

    private static boolean isAcceptable(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCatchSection) {
            PsiType type2 = ((PsiCatchSection)parent).getCatchType();
            return type2 instanceof PsiDisjunctionType;
        }
        return false;
    }

    private static class SplitMultiCatchFix
    extends InspectionGadgetsFix {
        private SplitMultiCatchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("multi.catch.can.be.split.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            MultiCatchCanBeSplitInspection.doFixImpl(descriptor.getPsiElement());
        }
    }

    private static class SplitMultiCatchVisitor
    extends BaseInspectionVisitor {
        private SplitMultiCatchVisitor() {
        }

        public void visitParameter(PsiParameter parameter2) {
            super.visitParameter(parameter2);
            if (MultiCatchCanBeSplitInspection.isAcceptable((PsiElement)parameter2)) {
                this.registerError((PsiElement)parameter2, new Object[0]);
            }
        }

        public void visitKeyword(PsiKeyword keyword) {
            super.visitKeyword(keyword);
            if (this.isOnTheFly() && keyword.getTokenType() == JavaTokenType.CATCH_KEYWORD && MultiCatchCanBeSplitInspection.isAcceptable((PsiElement)keyword)) {
                this.registerError((PsiElement)keyword, new Object[0]);
            }
        }
    }
}

