/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class NullThrownInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("null.thrown.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ThrowNullFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowNullVisitor();
    }

    private static class ThrowNullVisitor
    extends BaseInspectionVisitor {
        private ThrowNullVisitor() {
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            super.visitThrowStatement(statement);
            PsiExpression exception = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getException());
            if (!(exception instanceof PsiLiteralExpression)) {
                return;
            }
            PsiType type2 = exception.getType();
            if (!PsiType.NULL.equals((Object)type2)) {
                return;
            }
            this.registerError((PsiElement)exception, new Object[0]);
        }
    }

    private static class ThrowNullFix
    extends InspectionGadgetsFix {
        private ThrowNullFix() {
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{new NullPointerException()});
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression newExpression = factory.createExpressionFromText("new java.lang.NullPointerException()", element);
            element.replace((PsiElement)newExpression);
        }
    }
}

