/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.ui.ExternalizableStringSet;
import com.siyeh.ig.ui.UiUtils;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class BadExceptionThrownInspection
extends BaseInspection {
    public String exceptionsString = "";
    public final ExternalizableStringSet exceptions = new ExternalizableStringSet("java.lang.Throwable", "java.lang.Exception", "java.lang.Error", "java.lang.RuntimeException", "java.lang.NullPointerException", "java.lang.ClassCastException", "java.lang.ArrayIndexOutOfBoundsException");

    public BadExceptionThrownInspection() {
        if (!this.exceptionsString.isEmpty()) {
            this.exceptions.clear();
            List strings = StringUtil.split((String)this.exceptionsString, (String)",");
            this.exceptions.addAll(strings);
            this.exceptionsString = "";
        }
    }

    public JComponent createOptionsPanel() {
        ListTable table = new ListTable(new ListWrappingTableModel((List)((Object)this.exceptions), InspectionGadgetsBundle.message("exception.class.column.name", new Object[0])));
        return UiUtils.createAddRemoveTreeClassChooserPanel(table, InspectionGadgetsBundle.message("choose.exception.class", new Object[0]), "java.lang.Throwable");
    }

    @NotNull
    public String getID() {
        return "ProhibitedExceptionThrown";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        String exceptionName = type2.getPresentableText();
        return InspectionGadgetsBundle.message("bad.exception.thrown.problem.descriptor", exceptionName);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BadExceptionThrownVisitor();
    }

    private class BadExceptionThrownVisitor
    extends BaseInspectionVisitor {
        private BadExceptionThrownVisitor() {
        }

        public void visitThrowStatement(PsiThrowStatement statement) {
            super.visitThrowStatement(statement);
            PsiExpression exception = statement.getException();
            if (exception == null) {
                return;
            }
            PsiType type2 = exception.getType();
            if (type2 == null) {
                return;
            }
            String text2 = type2.getCanonicalText();
            if (BadExceptionThrownInspection.this.exceptions.contains(text2)) {
                this.registerStatementError((PsiStatement)statement, type2);
            }
        }
    }
}

