/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryReturnInspection
extends BaseInspection {
    public boolean ignoreInThenBranch = false;

    @NotNull
    public String getID() {
        return "UnnecessaryReturnStatement";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        if (((Boolean)infos[0]).booleanValue()) {
            return InspectionGadgetsBundle.message("unnecessary.return.constructor.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("unnecessary.return.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.return.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInThenBranch");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteUnnecessaryStatementFix("return");
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryReturnVisitor();
    }

    public static boolean isReturnRedundant(@NotNull PsiReturnStatement statement, boolean ignoreInThenBranch, boolean checkReturnType, @Nullable Ref<? super Boolean> isInConstructorRef) {
        if (statement.getReturnValue() != null) {
            return false;
        }
        PsiElement methodParent = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        PsiCodeBlock codeBlock = null;
        if (methodParent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)methodParent;
            codeBlock = method.getBody();
            if (isInConstructorRef != null) {
                isInConstructorRef.set((Object)method.isConstructor());
            }
            if (checkReturnType && !method.isConstructor() && !PsiType.VOID.equals((Object)method.getReturnType())) {
                return false;
            }
        } else if (methodParent instanceof PsiLambdaExpression) {
            if (isInConstructorRef != null) {
                isInConstructorRef.set((Object)false);
            }
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)methodParent;
            if (checkReturnType && !PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression))) {
                return false;
            }
            PsiElement lambdaBody = lambdaExpression.getBody();
            if (lambdaBody instanceof PsiCodeBlock) {
                codeBlock = (PsiCodeBlock)lambdaBody;
            }
        } else {
            return false;
        }
        if (codeBlock == null) {
            return false;
        }
        if (!ControlFlowUtils.blockCompletesWithStatement(codeBlock, (PsiStatement)statement) || ControlFlowUtils.isInFinallyBlock((PsiElement)statement)) {
            return false;
        }
        return !ignoreInThenBranch || !UnnecessaryReturnInspection.isInThenBranch((PsiStatement)statement);
    }

    static boolean isInThenBranch(PsiStatement statement) {
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (ifStatement == null) {
            return false;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch != null && !PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)statement, (boolean)true);
    }

    private class UnnecessaryReturnVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryReturnVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            super.visitReturnStatement(statement);
            Ref constructorRef = Ref.create();
            if (UnnecessaryReturnInspection.isReturnRedundant(statement, UnnecessaryReturnInspection.this.ignoreInThenBranch, true, (Ref<? super Boolean>)constructorRef)) {
                this.registerStatementError((PsiStatement)statement, constructorRef.get());
            }
        }
    }
}

