/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.style.ConditionalExpressionGenerator;
import com.siyeh.ig.style.IfConditionalModel;
import java.util.Objects;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrivialIfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreChainedIf = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "RedundantIfStatement";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("trivial.if.option.ignore.chained", new Object[0]), (InspectionProfileEntry)this, "ignoreChainedIf");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("trivial.if.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        boolean chainedIf = (Boolean)infos[0];
        if (chainedIf) {
            return new InspectionGadgetsFix[]{new TrivialIfFix(), new DelegatingFix(new SetInspectionOptionFix((LocalInspectionTool)this, "ignoreChainedIf", InspectionGadgetsBundle.message("trivial.if.option.ignore.chained", new Object[0]), true))};
        }
        return new InspectionGadgetsFix[]{new TrivialIfFix()};
    }

    private static void simplify(PsiIfStatement statement) {
        ConditionalExpressionGenerator generator;
        IfConditionalModel model = IfConditionalModel.from(statement, true);
        if (model != null && (generator = ConditionalExpressionGenerator.from(model)) != null) {
            CommentTracker ct = new CommentTracker();
            String text2 = generator.generate(ct);
            if (model.getElseExpression().textMatches((CharSequence)text2) && !PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)model.getElseBranch(), (boolean)false)) {
                ct.deleteAndRestoreComments((PsiElement)statement);
            } else {
                ct.replace((PsiElement)model.getThenExpression(), text2);
                ct.replaceAndRestoreComments((PsiElement)statement, (PsiElement)model.getThenBranch());
                PsiStatement elseBranch = model.getElseBranch();
                if (elseBranch.isValid() && (elseBranch instanceof PsiExpressionStatement || !ControlFlowUtils.isReachable(elseBranch))) {
                    PsiElement sibling = elseBranch.getPrevSibling();
                    if (sibling instanceof PsiWhiteSpace) {
                        sibling.delete();
                    }
                    new CommentTracker().deleteAndRestoreComments((PsiElement)elseBranch);
                }
            }
        }
        if (TrivialIfInspection.isSimplifiableAssert(statement)) {
            TrivialIfInspection.replaceSimplifiableAssert(statement);
        }
    }

    private static void replaceSimplifiableAssert(PsiIfStatement statement) {
        PsiExpression condition2 = statement.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = BoolUtils.getNegatedExpressionText(condition2);
        if (statement.getElseBranch() != null) {
            return;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(statement.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        PsiExpression assertCondition = assertStatement.getAssertCondition();
        if (assertCondition == null) {
            return;
        }
        PsiExpression replacementCondition = JavaPsiFacade.getElementFactory((Project)statement.getProject()).createExpressionFromText(BoolUtils.isFalse(assertCondition) ? conditionText : conditionText + "||" + assertCondition.getText(), (PsiElement)statement);
        assertCondition.replace((PsiElement)replacementCondition);
        statement.replace((PsiElement)assertStatement);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
                boolean chainedIf;
                super.visitIfStatement(ifStatement);
                boolean bl = chainedIf = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)ifStatement) instanceof PsiIfStatement || ifStatement.getParent() instanceof PsiIfStatement && ((PsiIfStatement)ifStatement.getParent()).getElseBranch() == ifStatement;
                if (TrivialIfInspection.this.ignoreChainedIf && chainedIf && !this.isOnTheFly()) {
                    return;
                }
                PsiExpression condition2 = ifStatement.getCondition();
                if (condition2 == null) {
                    return;
                }
                if (TrivialIfInspection.isTrivial(ifStatement)) {
                    PsiElement anchor = Objects.requireNonNull(ifStatement.getFirstChild());
                    ProblemHighlightType level = TrivialIfInspection.this.ignoreChainedIf && chainedIf ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    boolean addIgnoreFix = chainedIf && !TrivialIfInspection.this.ignoreChainedIf && !InspectionProjectProfileManager.isInformationLevel((String)TrivialIfInspection.this.getShortName(), (PsiElement)ifStatement);
                    this.registerError(anchor, level, new Object[]{addIgnoreFix});
                }
            }
        };
    }

    private static boolean isTrivial(PsiIfStatement ifStatement) {
        ConditionalExpressionGenerator generator;
        if (PsiUtilCore.hasErrorElementChild((PsiElement)ifStatement)) {
            return false;
        }
        IfConditionalModel model = IfConditionalModel.from(ifStatement, true);
        if (model != null && (generator = ConditionalExpressionGenerator.from(model)) != null && generator.getTokenType().isEmpty()) {
            return true;
        }
        return TrivialIfInspection.isSimplifiableAssert(ifStatement);
    }

    private static boolean isSimplifiableAssert(PsiIfStatement ifStatement) {
        if (ifStatement.getElseBranch() != null) {
            return false;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenBranch instanceof PsiAssertStatement)) {
            return false;
        }
        PsiAssertStatement assertStatement = (PsiAssertStatement)thenBranch;
        return assertStatement.getAssertCondition() != null;
    }

    private static class TrivialIfFix
    extends InspectionGadgetsFix {
        private TrivialIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("trivial.if.fix.family.name", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement ifKeywordElement = descriptor.getPsiElement();
            PsiIfStatement statement = (PsiIfStatement)ifKeywordElement.getParent();
            TrivialIfInspection.simplify(statement);
        }
    }
}

