/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public class ConditionalExpressionWithIdenticalBranchesInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new CollapseConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionWithIdenticalBranchesVisitor();
    }

    private static class ConditionalExpressionWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionWithIdenticalBranchesVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            super.visitConditionalExpression(expression2);
            PsiExpression thenExpression2 = expression2.getThenExpression();
            if (thenExpression2 == null) {
                return;
            }
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression2, elseExpression2)) {
                this.registerError((PsiElement)expression2, new Object[0]);
            }
        }
    }

    private static class CollapseConditionalFix
    extends InspectionGadgetsFix {
        private CollapseConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("conditional.expression.with.identical.branches.collapse.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)descriptor.getPsiElement();
            PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
            if (thenExpression2 == null) {
                return;
            }
            PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
            if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression2, elseExpression2)) {
                CommentTracker commentTracker = new CommentTracker();
                PsiReplacementUtil.replaceExpression((PsiExpression)conditionalExpression, commentTracker.text((PsiElement)thenExpression2), commentTracker);
            }
        }
    }
}

