/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import org.jetbrains.annotations.NotNull;

public class BooleanExpressionMayBeConditionalInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("if.may.be.conditional.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new BooleanExpressionMayBeConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BooleanExpressionMayBeConditionalVisitor();
    }

    private static class BooleanExpressionMayBeConditionalVisitor
    extends BaseInspectionVisitor {
        private BooleanExpressionMayBeConditionalVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            PsiExpression expression22;
            super.visitBinaryExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!JavaTokenType.OROR.equals(tokenType)) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getLOperand());
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getROperand());
            if (!(lhs instanceof PsiBinaryExpression) || !(rhs instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression lBinaryExpression = (PsiBinaryExpression)lhs;
            PsiBinaryExpression rBinaryExpression = (PsiBinaryExpression)rhs;
            IElementType lTokenType = lBinaryExpression.getOperationTokenType();
            IElementType rTokenType = rBinaryExpression.getOperationTokenType();
            if (!JavaTokenType.ANDAND.equals(lTokenType) || !JavaTokenType.ANDAND.equals(rTokenType)) {
                return;
            }
            PsiExpression expression1 = PsiUtil.skipParenthesizedExprDown((PsiExpression)lBinaryExpression.getLOperand());
            if (BoolUtils.areExpressionsOpposite(expression1, expression22 = PsiUtil.skipParenthesizedExprDown((PsiExpression)rBinaryExpression.getLOperand())) && !SideEffectChecker.mayHaveSideEffects(expression1)) {
                this.registerError((PsiElement)expression2, new Object[0]);
            }
        }
    }

    private static class BooleanExpressionMayBeConditionalFix
    extends InspectionGadgetsFix {
        private BooleanExpressionMayBeConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("if.may.be.conditional.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getLOperand());
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getROperand());
            if (!(lhs instanceof PsiBinaryExpression) || !(rhs instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression lBinaryExpression = (PsiBinaryExpression)lhs;
            PsiBinaryExpression rBinaryExpression = (PsiBinaryExpression)rhs;
            PsiExpression llhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)lBinaryExpression.getLOperand());
            PsiExpression lrhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)rBinaryExpression.getLOperand());
            if (llhs == null || lrhs == null) {
                return;
            }
            PsiExpression thenExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)lBinaryExpression.getROperand());
            PsiExpression elseExpression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)rBinaryExpression.getROperand());
            if (thenExpression2 == null || elseExpression2 == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            if (BoolUtils.isNegation(llhs)) {
                PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, BooleanExpressionMayBeConditionalFix.getText(lrhs, commentTracker) + '?' + BooleanExpressionMayBeConditionalFix.getText(elseExpression2, commentTracker) + ':' + BooleanExpressionMayBeConditionalFix.getText(thenExpression2, commentTracker), commentTracker);
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)binaryExpression, BooleanExpressionMayBeConditionalFix.getText(llhs, commentTracker) + '?' + BooleanExpressionMayBeConditionalFix.getText(thenExpression2, commentTracker) + ':' + BooleanExpressionMayBeConditionalFix.getText(elseExpression2, commentTracker), commentTracker);
            }
        }

        private static String getText(@NotNull PsiExpression expression2, CommentTracker commentTracker) {
            return ParenthesesUtils.getText(commentTracker.markUnchanged(expression2), 15);
        }
    }
}

