/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldFinalFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticNonFinalFieldInspection
extends BaseInspection {
    public boolean ignoreNonPublicFields = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("static.non.final.field.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldFinalFix.buildFix(field);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("static.non.final.field.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNonPublicFields");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticNonFinalFieldVisitor();
    }

    private class StaticNonFinalFieldVisitor
    extends BaseInspectionVisitor {
        private StaticNonFinalFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (StaticNonFinalFieldInspection.this.ignoreNonPublicFields && !field.hasModifierProperty("public")) {
                return;
            }
            if (!field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
                return;
            }
            this.registerFieldError(field, field);
        }
    }
}

