/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ConstantDeclaredInAbstractClassInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("constant.declared.in.abstract.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantDeclaredInAbstractClassVisitor();
    }

    private static class ConstantDeclaredInAbstractClassVisitor
    extends BaseInspectionVisitor {
        private ConstantDeclaredInAbstractClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (!(field.hasModifierProperty("static") && field.hasModifierProperty("public") && field.hasModifierProperty("final"))) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType() || containingClass.isEnum()) {
                return;
            }
            if (!containingClass.hasModifierProperty("abstract")) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

