/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullArgumentToVariableArgMethodInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ConfusingArgumentToVarargsMethod";
    }

    @Nullable
    public String getAlternativeID() {
        return "NullArgumentToVariableArgMethod";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("null.argument.to.var.arg.method.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        PsiExpression argument = (PsiExpression)infos[0];
        PsiType type1 = (PsiType)infos[1];
        PsiType type2 = (PsiType)infos[2];
        return new InspectionGadgetsFix[]{new DelegatingFix((LocalQuickFix)new AddTypeCastFix(type1, argument)), new DelegatingFix((LocalQuickFix)new AddTypeCastFix(type2, argument))};
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NullArgumentToVariableArgVisitor();
    }

    public static boolean isSuspiciousVararg(PsiCall call, PsiType lastArgumentType, Supplier<PsiMethod> methodSupplier) {
        return NullArgumentToVariableArgVisitor.getSuspiciousVarargType(call, lastArgumentType, methodSupplier) != null;
    }

    private static class NullArgumentToVariableArgVisitor
    extends BaseInspectionVisitor {
        private NullArgumentToVariableArgVisitor() {
        }

        public void visitEnumConstant(PsiEnumConstant enumConstant) {
            super.visitEnumConstant(enumConstant);
            this.visitCall((PsiCall)enumConstant);
        }

        public void visitCallExpression(PsiCallExpression call) {
            super.visitCallExpression(call);
            this.visitCall((PsiCall)call);
        }

        private static PsiArrayType getSuspiciousVarargType(PsiCall call, PsiType type2, Supplier<PsiMethod> resolver) {
            boolean checkArray;
            if (PsiType.NULL.equals((Object)type2)) {
                checkArray = false;
            } else if (type2 instanceof PsiArrayType) {
                checkArray = true;
            } else {
                return null;
            }
            PsiMethod method = resolver.get();
            if (method == null) {
                return null;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiExpressionList argumentList = call.getArgumentList();
            if (argumentList == null || parameterList.getParametersCount() != argumentList.getExpressionCount()) {
                return null;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            PsiParameter lastParameter = parameters2[parameters2.length - 1];
            if (!lastParameter.isVarArgs()) {
                return null;
            }
            PsiType type1 = lastParameter.getType();
            if (!(type1 instanceof PsiEllipsisType)) {
                return null;
            }
            PsiEllipsisType ellipsisType = (PsiEllipsisType)type1;
            PsiArrayType arrayType = (PsiArrayType)ellipsisType.toArrayType();
            PsiType componentType = arrayType.getComponentType();
            if (checkArray) {
                if (!componentType.equals(TypeUtils.getObjectType((PsiElement)call))) {
                    return null;
                }
                if (type2.isAssignableFrom((PsiType)arrayType) || !arrayType.isAssignableFrom(type2)) {
                    return null;
                }
            }
            return arrayType;
        }

        private void visitCall(PsiCall call) {
            PsiExpressionList argumentList = call.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression lastArgument = arguments[arguments.length - 1];
            PsiType type2 = lastArgument.getType();
            PsiArrayType arrayType = NullArgumentToVariableArgVisitor.getSuspiciousVarargType(call, type2, () -> ((PsiCall)call).resolveMethod());
            if (arrayType == null) {
                return;
            }
            this.registerError((PsiElement)lastArgument, lastArgument, arrayType.getComponentType(), arrayType);
        }
    }
}

