/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EqualsOnSuspiciousObjectInspection
extends BaseInspection {
    private final List<String> myClasses = Arrays.asList("java.lang.StringBuilder", "java.lang.StringBuffer");

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String typeName = (String)infos[0];
        return InspectionGadgetsBundle.message("equals.called.on.suspicious.object.problem.descriptor", StringUtil.getShortName((String)typeName));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseEqualsVisitor(){

            @Override
            void checkTypes(@NotNull PsiReferenceExpression expression2, @NotNull PsiType type1, @NotNull PsiType type2) {
                if (!this.checkType(expression2, type1)) {
                    this.checkType(expression2, type2);
                }
            }

            private boolean checkType(PsiReferenceExpression expression2, PsiType type2) {
                PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
                if (psiClass != null) {
                    String qualifiedName = psiClass.getQualifiedName();
                    if (EqualsOnSuspiciousObjectInspection.this.myClasses.contains(qualifiedName)) {
                        PsiElement name2 = expression2.getReferenceNameElement();
                        this.registerError((PsiElement)(name2 == null ? expression2 : name2), qualifiedName);
                        return true;
                    }
                }
                return false;
            }
        };
    }
}

