/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class ArrayEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("array.comparison.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiArrayType type2 = (PsiArrayType)infos[0];
        PsiType componentType = type2.getComponentType();
        if (componentType instanceof PsiArrayType) {
            return new ArrayEqualityFix(true);
        }
        return new ArrayEqualityFix(false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayEqualityVisitor();
    }

    private static class ArrayEqualityVisitor
    extends BaseInspectionVisitor {
        private ArrayEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null || !ComparisonUtils.isEqualityComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            PsiType lhsType = lhs.getType();
            if (!(lhsType instanceof PsiArrayType) || !(rhs.getType() instanceof PsiArrayType)) {
                return;
            }
            this.registerError((PsiElement)expression2.getOperationSign(), lhsType);
        }
    }

    private static class ArrayEqualityFix
    extends InspectionGadgetsFix {
        private final boolean deepEquals;

        ArrayEqualityFix(boolean deepEquals) {
            this.deepEquals = deepEquals;
        }

        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.deepEquals ? "Arrays.deepEquals()" : "Arrays.equals()"});
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Arrays.equals()"});
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiBinaryExpression)) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            StringBuilder newExpressionText = new StringBuilder();
            if (JavaTokenType.NE.equals(tokenType)) {
                newExpressionText.append('!');
            } else if (!JavaTokenType.EQEQ.equals(tokenType)) {
                return;
            }
            if (this.deepEquals) {
                newExpressionText.append("java.util.Arrays.deepEquals(");
            } else {
                newExpressionText.append("java.util.Arrays.equals(");
            }
            newExpressionText.append(commentTracker.text((PsiElement)binaryExpression.getLOperand()));
            newExpressionText.append(',');
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            newExpressionText.append(commentTracker.text((PsiElement)rhs));
            newExpressionText.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)binaryExpression, newExpressionText.toString(), commentTracker);
        }
    }
}

