/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverlyStrongTypeCastInspection
extends BaseInspection {
    public boolean ignoreInMatchingInstanceof = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType expectedType = (PsiType)infos[0];
        String typeText = expectedType.getPresentableText();
        return InspectionGadgetsBundle.message("overly.strong.type.cast.problem.descriptor", typeText);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("overly.strong.type.cast.ignore.in.matching.instanceof.option", new Object[0]), (InspectionProfileEntry)this, "ignoreInMatchingInstanceof");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new OverlyStrongCastFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyStrongTypeCastVisitor();
    }

    private class OverlyStrongTypeCastVisitor
    extends BaseInspectionVisitor {
        private OverlyStrongTypeCastVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression2) {
            PsiArrayType arrayType;
            PsiType componentType;
            super.visitTypeCastExpression(expression2);
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiType operandType = operand2.getType();
            if (operandType == null) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, true);
            if (expectedType == null || expectedType.equals(type2)) {
                return;
            }
            PsiClass resolved = PsiUtil.resolveClassInType((PsiType)expectedType);
            if (resolved != null && !resolved.isPhysical()) {
                return;
            }
            if (expectedType.isAssignableFrom(operandType) && !MethodCallUtils.isNecessaryForSurroundingMethodCall((PsiExpression)expression2, operand2)) {
                return;
            }
            if (TypeUtils.isTypeParameter(expectedType)) {
                return;
            }
            if (expectedType instanceof PsiArrayType && TypeUtils.isTypeParameter(componentType = (arrayType = (PsiArrayType)expectedType).getDeepComponentType())) {
                return;
            }
            if (type2 instanceof PsiPrimitiveType || expectedType instanceof PsiPrimitiveType) {
                return;
            }
            if (PsiPrimitiveType.getUnboxedType((PsiType)type2) != null || PsiPrimitiveType.getUnboxedType((PsiType)expectedType) != null) {
                return;
            }
            if (expectedType instanceof PsiClassType) {
                PsiClassType classType;
                PsiClassType rawType;
                PsiClassType expectedClassType = (PsiClassType)expectedType;
                PsiClassType expectedRawType = expectedClassType.rawType();
                if (type2.equals(expectedRawType)) {
                    return;
                }
                if (type2 instanceof PsiClassType && (rawType = (classType = (PsiClassType)type2).rawType()).equals((Object)expectedRawType)) {
                    return;
                }
                if (type2 instanceof PsiArrayType) {
                    return;
                }
            }
            if (OverlyStrongTypeCastInspection.this.ignoreInMatchingInstanceof && InstanceOfUtils.hasAgreeingInstanceof(expression2)) {
                return;
            }
            PsiTypeElement castTypeElement = expression2.getCastType();
            if (castTypeElement == null) {
                return;
            }
            if (operand2 instanceof PsiFunctionalExpression) {
                if (!LambdaUtil.isFunctionalType((PsiType)expectedType)) {
                    return;
                }
                PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)expectedType);
                if (interfaceReturnType instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)interfaceReturnType) != null) {
                    return;
                }
            }
            this.registerError((PsiElement)castTypeElement, expectedType);
        }
    }

    private static class OverlyStrongCastFix
    extends InspectionGadgetsFix {
        private OverlyStrongCastFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("overly.strong.type.cast.weaken.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement castTypeElement = descriptor.getPsiElement();
            PsiTypeCastExpression expression2 = (PsiTypeCastExpression)castTypeElement.getParent();
            if (expression2 == null) {
                return;
            }
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, true);
            if (expectedType == null) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String newExpression = '(' + expectedType.getCanonicalText() + ')' + commentTracker.text((PsiElement)operand2);
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression2, newExpression, commentTracker);
        }
    }
}

