/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.CanonicalPsiTypeConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanonicalPsiTypeConverterImpl
extends CanonicalPsiTypeConverter
implements CustomReferenceConverter<PsiType> {
    @NonNls
    static final String[] PRIMITIVES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    @NonNls
    private static final String ARRAY_PREFIX = "[L";

    public PsiType fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        try {
            return JavaPsiFacade.getElementFactory((Project)context.getFile().getProject()).createTypeFromText(s.replace('$', '.'), null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public String toString(PsiType t, ConvertContext context) {
        return t == null ? null : t.getCanonicalText();
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<PsiType> genericDomValue, PsiElement element, ConvertContext context) {
        String typeText = genericDomValue.getStringValue();
        if (typeText == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        return this.getReferences((PsiType)genericDomValue.getValue(), typeText, 0, element);
    }

    public PsiReference[] getReferences(@Nullable PsiType type2, String typeText, int startOffsetInText, final @NotNull PsiElement element) {
        String trimmed = typeText.trim();
        int offset = ElementManipulators.getValueTextRange((PsiElement)element).getStartOffset() + startOffsetInText + typeText.indexOf(trimmed);
        if (trimmed.startsWith(ARRAY_PREFIX)) {
            offset += ARRAY_PREFIX.length();
            trimmed = trimmed.endsWith(";") ? trimmed.substring(ARRAY_PREFIX.length(), trimmed.length() - 1) : trimmed.substring(ARRAY_PREFIX.length());
        }
        if (type2 != null) {
            type2 = type2.getDeepComponentType();
        }
        final boolean isPrimitiveType = type2 instanceof PsiPrimitiveType;
        return new JavaClassReferenceSet(trimmed, element, offset, false, new JavaClassReferenceProvider()){

            @Override
            @NotNull
            protected JavaClassReference createReference(int refIndex, @NotNull String subRefText, @NotNull TextRange textRange, boolean staticImport) {
                return new JavaClassReference(this, textRange, refIndex, subRefText, staticImport){

                    @Override
                    public boolean isSoft() {
                        return true;
                    }

                    @Override
                    @NotNull
                    public JavaResolveResult advancedResolve(boolean incompleteCode) {
                        if (isPrimitiveType) {
                            return new CandidateInfo(element, PsiSubstitutor.EMPTY, false, false, element);
                        }
                        return super.advancedResolve(incompleteCode);
                    }

                    @Override
                    public void processVariants(@NotNull PsiScopeProcessor processor2) {
                        if (processor2 instanceof JavaCompletionProcessor) {
                            ((JavaCompletionProcessor)processor2).setCompletionElements(this.getVariants());
                        } else {
                            super.processVariants(processor2);
                        }
                    }

                    @Override
                    public Object @NotNull [] getVariants() {
                        Object[] variants = super.getVariants();
                        if (this.myIndex == 0) {
                            return ArrayUtil.mergeArrays((Object[])variants, (Object[])PRIMITIVES, (ArrayFactory)ArrayUtil.OBJECT_ARRAY_FACTORY);
                        }
                        return variants;
                    }
                };
            }
        }.getAllReferences();
    }
}

