/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.impl.ConfigFileContainerImpl;
import java.lang.ref.Reference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigFileImpl
extends SimpleModificationTracker
implements ConfigFile {
    @NotNull
    private ConfigFileInfo myInfo;
    private final VirtualFilePointer myFilePointer;
    private volatile Reference<PsiFile> myPsiFile;
    private final ConfigFileContainerImpl myContainer;
    private final Project myProject;

    public ConfigFileImpl(@NotNull ConfigFileContainerImpl container, @NotNull ConfigFileInfo configuration) {
        this.myContainer = container;
        this.myInfo = configuration;
        VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
        this.myFilePointer = pointerManager.create(configuration.getUrl(), (Disposable)this, new VirtualFilePointerListener(){

            public void validityChanged(VirtualFilePointer @NotNull [] pointers) {
                ConfigFileImpl.this.myPsiFile = null;
                ConfigFileImpl.this.onChange();
            }
        });
        this.onChange();
        this.myProject = this.myContainer.getProject();
    }

    private void onChange() {
        this.incModificationCount();
        this.myContainer.fireDescriptorChanged(this);
    }

    public String getUrl() {
        return this.myFilePointer.getUrl();
    }

    public void setInfo(@NotNull ConfigFileInfo info) {
        this.myInfo = info;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myFilePointer.isValid() ? this.myFilePointer.getFile() : null;
    }

    @Nullable
    public PsiFile getPsiFile() {
        PsiFile psiFile = (PsiFile)SoftReference.dereference(this.myPsiFile);
        if (psiFile != null && psiFile.isValid()) {
            return psiFile;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
        this.myPsiFile = new java.lang.ref.SoftReference<PsiFile>(psiFile);
        return psiFile;
    }

    @Nullable
    public XmlFile getXmlFile() {
        PsiFile file = this.getPsiFile();
        return file instanceof XmlFile ? (XmlFile)file : null;
    }

    public void dispose() {
    }

    @NotNull
    public ConfigFileInfo getInfo() {
        return this.myInfo;
    }

    public boolean isValid() {
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null || !psiFile.isValid()) {
            return false;
        }
        if (psiFile instanceof XmlFile) {
            XmlDocument document = ((XmlFile)psiFile).getDocument();
            return document != null && document.getRootTag() != null;
        }
        return true;
    }

    @NotNull
    public ConfigFileMetaData getMetaData() {
        return this.myInfo.getMetaData();
    }
}

